/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.standard.action.data.file.impl;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.drombler.acp.core.commons.util.SimpleServiceTrackerCustomizer;
import org.drombler.acp.core.commons.util.concurrent.ApplicationThreadConsumer;
import org.drombler.acp.core.data.spi.DataHandlerRegistryProvider;
import org.drombler.acp.core.data.spi.DocumentHandlerDescriptorRegistryProvider;
import org.drombler.acp.core.data.spi.FileExtensionDescriptorRegistryProvider;
import org.drombler.acp.startup.main.ApplicationExecutorProvider;
import org.drombler.commons.action.AbstractActionListener;
import org.drombler.commons.client.dialog.FileChooserProvider;
import org.drombler.commons.data.DataHandlerRegistry;
import org.drombler.commons.data.file.DocumentHandlerDescriptorRegistry;
import org.drombler.commons.data.file.FileExtensionDescriptorRegistry;
import org.drombler.commons.data.file.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class OpenFilesAction
extends AbstractActionListener<Object>
implements AutoCloseable {
    private final ServiceTracker<ApplicationExecutorProvider, ApplicationExecutorProvider> applicationExecutorProviderServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker((BundleContext)FrameworkUtil.getBundle(OpenFilesAction.class).getBundleContext(), ApplicationExecutorProvider.class, this::setApplicationExecutorProvider);
    private ServiceTracker<FileChooserProvider, FileChooserProvider> fileChooserProviderServiceTracker;
    private ServiceTracker<FileExtensionDescriptorRegistryProvider, FileExtensionDescriptorRegistryProvider> fileExtensionDescriptorRegistryProviderServiceTracker;
    private ServiceTracker<DocumentHandlerDescriptorRegistryProvider, DocumentHandlerDescriptorRegistryProvider> documentHandlerDescriptorRegistryServiceTracker;
    private ServiceTracker<DataHandlerRegistryProvider, DataHandlerRegistryProvider> dataHandlerRegistryServiceTracker;
    private FileChooserProvider fileChooserProvider;
    private FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider;
    private DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider;
    private DataHandlerRegistryProvider dataHandlerRegistryProvider;
    private ApplicationExecutorProvider applicationExecutorProvider;

    public OpenFilesAction() {
        this.applicationExecutorProviderServiceTracker.open(true);
        this.setEnabled(this.isInitialized());
    }

    public void onAction(Object event) {
        List filePaths = this.fileChooserProvider.showOpenMultipleDialog();
        if (filePaths != null) {
            filePaths.forEach(this::openFile);
        }
    }

    private boolean isInitialized() {
        return this.fileChooserProvider != null && this.fileExtensionDescriptorRegistryProvider != null && this.documentHandlerDescriptorRegistryProvider != null && this.dataHandlerRegistryProvider != null;
    }

    private void openFile(Path fileToOpen) {
        FileUtils.openFile((Path)fileToOpen, (DataHandlerRegistry)this.dataHandlerRegistryProvider.getDataHandlerRegistry(), (FileExtensionDescriptorRegistry)this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry(), (DocumentHandlerDescriptorRegistry)this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry());
    }

    public ApplicationExecutorProvider getApplicationExecutorProvider() {
        return this.applicationExecutorProvider;
    }

    public void setApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutorProvider = applicationExecutorProvider;
        if (this.applicationExecutorProvider != null) {
            this.fileChooserProviderServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(FileChooserProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationExecutorProvider, this::setFileChooserProvider));
            this.fileExtensionDescriptorRegistryProviderServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(FileExtensionDescriptorRegistryProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationExecutorProvider, this::setFileExtensionDescriptorRegistryProvider));
            this.documentHandlerDescriptorRegistryServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(DocumentHandlerDescriptorRegistryProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationExecutorProvider, this::setDocumentHandlerDescriptorRegistryProvider));
            this.dataHandlerRegistryServiceTracker = SimpleServiceTrackerCustomizer.createServiceTracker(DataHandlerRegistryProvider.class, (Consumer)new ApplicationThreadConsumer(this.applicationExecutorProvider, this::setDataHandlerRegistryProvider));
            this.fileChooserProviderServiceTracker.open(true);
            this.fileExtensionDescriptorRegistryProviderServiceTracker.open(true);
            this.documentHandlerDescriptorRegistryServiceTracker.open(true);
            this.dataHandlerRegistryServiceTracker.open(true);
        } else {
            this.fileChooserProviderServiceTracker.close();
            this.fileChooserProviderServiceTracker = null;
            this.fileExtensionDescriptorRegistryProviderServiceTracker.close();
            this.fileExtensionDescriptorRegistryProviderServiceTracker = null;
            this.documentHandlerDescriptorRegistryServiceTracker.close();
            this.documentHandlerDescriptorRegistryServiceTracker = null;
            this.dataHandlerRegistryServiceTracker.close();
            this.dataHandlerRegistryServiceTracker = null;
        }
    }

    public FileChooserProvider getFileChooserProvider() {
        return this.fileChooserProvider;
    }

    public void setFileChooserProvider(FileChooserProvider fileChooserProvider) {
        this.fileChooserProvider = fileChooserProvider;
        this.setEnabled(this.isInitialized());
    }

    public FileExtensionDescriptorRegistryProvider getFileExtensionDescriptorRegistryProvider() {
        return this.fileExtensionDescriptorRegistryProvider;
    }

    public void setFileExtensionDescriptorRegistryProvider(FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider) {
        this.fileExtensionDescriptorRegistryProvider = fileExtensionDescriptorRegistryProvider;
        this.setEnabled(this.isInitialized());
    }

    public DocumentHandlerDescriptorRegistryProvider getDocumentHandlerDescriptorRegistryProvider() {
        return this.documentHandlerDescriptorRegistryProvider;
    }

    public void setDocumentHandlerDescriptorRegistryProvider(DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider) {
        this.documentHandlerDescriptorRegistryProvider = documentHandlerDescriptorRegistryProvider;
        this.setEnabled(this.isInitialized());
    }

    public DataHandlerRegistryProvider getDataHandlerRegistryProvider() {
        return this.dataHandlerRegistryProvider;
    }

    public void setDataHandlerRegistryProvider(DataHandlerRegistryProvider dataHandlerRegistryProvider) {
        this.dataHandlerRegistryProvider = dataHandlerRegistryProvider;
        this.setEnabled(this.isInitialized());
    }

    @Override
    public void close() {
        this.applicationExecutorProviderServiceTracker.close();
    }
}

