/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.drombler.acp.core.docking.jaxb.DockingsType;
import org.drombler.acp.core.docking.spi.EditorDockingDescriptor;
import org.drombler.acp.core.docking.spi.impl.AbstractDockableDockingHandler;
import org.drombler.commons.docking.DockableData;
import org.drombler.commons.docking.DockableEntry;
import org.drombler.commons.docking.DockablePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Reference(name="editorDockingDescriptor", referenceInterface=EditorDockingDescriptor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class EditorDockingHandler<D, DATA extends DockableData, E extends DockableEntry<D>>
extends AbstractDockableDockingHandler<D, DATA, E> {
    private static final Logger LOG = LoggerFactory.getLogger(EditorDockingHandler.class);
    private final List<EditorDockingDescriptor> unresolvedDockingDescriptors = new ArrayList<EditorDockingDescriptor>();

    protected void bindEditorDockingDescriptor(EditorDockingDescriptor dockingDescriptor) {
        this.resolveDockingDescriptor(dockingDescriptor);
    }

    protected void unbindEditorDockingDescriptor(EditorDockingDescriptor dockingDescriptor) {
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resolveUnresolvedDockables();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    @Override
    protected void resolveDockingsType(DockingsType dockingsType, Bundle bundle, BundleContext context) {
        dockingsType.getEditorDocking().forEach(dockingType -> {
            try {
                EditorDockingDescriptor dockingDescriptor = EditorDockingDescriptor.createEditorDockingDescriptor(dockingType, bundle);
                this.resolveDockingDescriptor(dockingDescriptor);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        });
    }

    private void resolveDockingDescriptor(EditorDockingDescriptor dockingDescriptor) {
        if (this.isInitialized()) {
            DockableData dockableData = (DockableData)this.getDockableDataFactory().createDockableData(dockingDescriptor);
            this.registerClassDockableData(dockingDescriptor.getDockableClass(), dockableData);
            DockablePreferences dockablePreferences = this.createDockablePreferences(dockingDescriptor.getAreaId(), 0);
            this.registerDefaultDockablePreferences(dockingDescriptor.getDockableClass(), dockablePreferences);
        } else {
            this.unresolvedDockingDescriptors.add(dockingDescriptor);
        }
    }

    private void resolveUnresolvedDockables() {
        this.unresolvedDockingDescriptors.forEach(unresolvedDockingDescriptor -> this.resolveDockingDescriptor((EditorDockingDescriptor)unresolvedDockingDescriptor));
    }
}

