/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi;

import java.util.ResourceBundle;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.drombler.acp.core.action.spi.MenuEntryDescriptor;
import org.drombler.acp.core.docking.jaxb.AbstractDockingType;
import org.drombler.acp.core.docking.jaxb.ViewDockingType;
import org.drombler.acp.core.docking.spi.AbstractDockableDockingDescriptor;
import org.drombler.acp.core.docking.spi.DockingDescriptorUtils;
import org.drombler.commons.client.util.MnemonicUtils;
import org.drombler.commons.client.util.ResourceBundleUtils;
import org.osgi.framework.Bundle;

public class ViewDockingDescriptor
extends AbstractDockableDockingDescriptor {
    private String displayName;
    private int position;
    private ActionDescriptor activateDockableActionDescriptor;
    private MenuEntryDescriptor activateDockableMenuEntryDescriptor;
    private ResourceBundle resourceBundle;

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ActionDescriptor getActivateDockableActionDescriptor() {
        return this.activateDockableActionDescriptor;
    }

    public void setActivateDockableActionDescriptor(ActionDescriptor activateDockableActionDescriptor) {
        this.activateDockableActionDescriptor = activateDockableActionDescriptor;
    }

    public static ViewDockingDescriptor createViewDockingDescriptor(ViewDockingType docking, Bundle bundle) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ViewDockingDescriptor dockingDescriptor = new ViewDockingDescriptor();
        DockingDescriptorUtils.configureDockingDescriptor(dockingDescriptor, (AbstractDockingType)docking, bundle);
        dockingDescriptor.setResourceBundle(ResourceBundleUtils.getResourceBundle(dockingDescriptor.getDockableClass(), (String)docking.getResourceBundleBaseName(), (String)docking.getDisplayName()));
        String displayName = ResourceBundleUtils.getResourceStringPrefixed((String)docking.getDisplayName(), (ResourceBundle)dockingDescriptor.getResourceBundle());
        dockingDescriptor.setDisplayName(MnemonicUtils.removeMnemonicChar((String)displayName));
        dockingDescriptor.setPosition(docking.getPosition());
        dockingDescriptor.setActivateDockableActionDescriptor(ViewDockingDescriptor.createActivateDockableActionDescriptor(dockingDescriptor, displayName, docking.getAccelerator()));
        dockingDescriptor.setActivateDockableMenuEntryDescriptor(new MenuEntryDescriptor(dockingDescriptor.getId(), ViewDockingDescriptor.getWindowPath(docking), docking.getMenuEntry().getPosition()));
        return dockingDescriptor;
    }

    private static String getWindowPath(ViewDockingType docking) {
        StringBuilder sb = new StringBuilder("Window");
        if (docking.getMenuEntry().getPath() != null) {
            sb.append("/");
            sb.append(docking.getMenuEntry().getPath());
        }
        return sb.toString();
    }

    private static ActionDescriptor createActivateDockableActionDescriptor(ViewDockingDescriptor dockingDescriptor, String displayName, String accelerator) {
        ActionDescriptor actionDescriptor = new ActionDescriptor();
        actionDescriptor.setId(dockingDescriptor.getId());
        actionDescriptor.setDisplayName(displayName);
        actionDescriptor.setAccelerator(accelerator);
        actionDescriptor.setIcon(dockingDescriptor.getIcon());
        actionDescriptor.setResourceLoader(dockingDescriptor.getResourceLoader());
        return actionDescriptor;
    }

    public MenuEntryDescriptor getActivateDockableMenuEntryDescriptor() {
        return this.activateDockableMenuEntryDescriptor;
    }

    public void setActivateDockableMenuEntryDescriptor(MenuEntryDescriptor activateDockableMenuEntryDescriptor) {
        this.activateDockableMenuEntryDescriptor = activateDockableMenuEntryDescriptor;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }
}

