/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.docking.jaxb.DockingAreaKindType;
import org.drombler.acp.core.docking.jaxb.DockingAreaType;
import org.drombler.acp.core.docking.spi.LayoutConstraintsDescriptorUtils;
import org.drombler.commons.docking.DockingAreaDescriptor;
import org.drombler.commons.docking.DockingAreaKind;

public class DockingAreaDescriptorUtils {
    private static final Map<DockingAreaKindType, DockingAreaKind> DOCKING_AREA_KINDS = new EnumMap<DockingAreaKindType, DockingAreaKind>(DockingAreaKindType.class);

    private DockingAreaDescriptorUtils() {
    }

    public static DockingAreaDescriptor createDockingAreaDescriptor(DockingAreaType dockingArea) {
        DockingAreaDescriptor dockingAreaDescriptor = new DockingAreaDescriptor();
        dockingAreaDescriptor.setId(StringUtils.stripToNull((String)dockingArea.getId()));
        dockingAreaDescriptor.setKind(DOCKING_AREA_KINDS.get(dockingArea.getKind()));
        dockingAreaDescriptor.setPosition(dockingArea.getPosition());
        dockingAreaDescriptor.setParentPath(new ArrayList(dockingArea.getPaths().getPath()));
        dockingAreaDescriptor.setPermanent(dockingArea.isPermanent());
        dockingAreaDescriptor.setLayoutConstraints(LayoutConstraintsDescriptorUtils.createLayoutConstraintsDescriptor(dockingArea.getLayoutConstraints()));
        return dockingAreaDescriptor;
    }

    static {
        DOCKING_AREA_KINDS.put(DockingAreaKindType.VIEW, DockingAreaKind.VIEW);
        DOCKING_AREA_KINDS.put(DockingAreaKindType.EDITOR, DockingAreaKind.EDITOR);
        for (DockingAreaKindType dockingAreaKind : DockingAreaKindType.values()) {
            if (DOCKING_AREA_KINDS.containsKey(dockingAreaKind)) continue;
            throw new IllegalStateException("No mapping for: " + dockingAreaKind);
        }
    }
}

