/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi;

import org.drombler.acp.core.docking.spi.DockableDataFactory;
import org.drombler.acp.core.docking.spi.DockableDataManagerProvider;
import org.drombler.acp.core.docking.spi.DockableEntryFactory;
import org.drombler.acp.core.docking.spi.DockablePreferencesManagerProvider;
import org.drombler.acp.core.docking.spi.DockingAreaContainerProvider;
import org.drombler.commons.context.ActiveContextProvider;
import org.drombler.commons.context.ApplicationContextProvider;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.docking.DockableData;
import org.drombler.commons.docking.DockableDataManager;
import org.drombler.commons.docking.DockableEntry;
import org.drombler.commons.docking.DockingInjector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class Dockables {
    private Dockables() {
    }

    public static <D, E extends DockableEntry<D>> void open(D dockable) {
        BundleContext bundleContext = FrameworkUtil.getBundle(Dockables.class).getBundleContext();
        ServiceReference dockablePreferencesManagerProviderServiceReference = bundleContext.getServiceReference(DockablePreferencesManagerProvider.class);
        DockablePreferencesManagerProvider dockablePreferencesManagerProvider = (DockablePreferencesManagerProvider)bundleContext.getService(dockablePreferencesManagerProviderServiceReference);
        ServiceReference dockingAreaContainerProviderServiceReference = bundleContext.getServiceReference(DockingAreaContainerProvider.class);
        DockingAreaContainerProvider dockingPaneProvider = (DockingAreaContainerProvider)bundleContext.getService(dockingAreaContainerProviderServiceReference);
        ServiceReference dockableEntryFactoryServiceReference = bundleContext.getServiceReference(DockableEntryFactory.class);
        DockableEntryFactory dockableEntryFactory = (DockableEntryFactory)bundleContext.getService(dockableEntryFactoryServiceReference);
        dockingPaneProvider.getDockingAreaContainer().addDockable(dockableEntryFactory.createDockableEntry(dockable, dockablePreferencesManagerProvider.getDockablePreferencesManager().getDockablePreferences(dockable)));
        bundleContext.ungetService(dockingAreaContainerProviderServiceReference);
        bundleContext.ungetService(dockablePreferencesManagerProviderServiceReference);
        bundleContext.ungetService(dockableEntryFactoryServiceReference);
    }

    public static <D> void inject(D dockable) {
        BundleContext bundleContext = FrameworkUtil.getBundle(Dockables.class).getBundleContext();
        Dockables.injectContexts(bundleContext, dockable);
        Dockables.injectDocking(bundleContext, dockable);
    }

    private static void injectContexts(BundleContext bundleContext, Object target) {
        ServiceReference activeContextProviderServiceReference = bundleContext.getServiceReference(ActiveContextProvider.class);
        ActiveContextProvider activeContextProvider = (ActiveContextProvider)bundleContext.getService(activeContextProviderServiceReference);
        ServiceReference applicationContextProviderServiceReference = bundleContext.getServiceReference(ApplicationContextProvider.class);
        ApplicationContextProvider applicationContextProvider = (ApplicationContextProvider)bundleContext.getService(applicationContextProviderServiceReference);
        ContextInjector contextInjector = new ContextInjector(activeContextProvider, applicationContextProvider);
        contextInjector.inject(target);
        bundleContext.ungetService(applicationContextProviderServiceReference);
        bundleContext.ungetService(activeContextProviderServiceReference);
    }

    private static <D, DATA extends DockableData> void injectDocking(BundleContext bundleContext, D dockable) {
        DockableData classDockableData;
        ServiceReference dockableDataManagerProviderServiceReference = bundleContext.getServiceReference(DockableDataManagerProvider.class);
        DockableDataManagerProvider dockableDataManagerProvider = (DockableDataManagerProvider)bundleContext.getService(dockableDataManagerProviderServiceReference);
        ServiceReference dockableDataFactoryServiceReference = bundleContext.getServiceReference(DockableDataFactory.class);
        DockableDataFactory dockableDataFactory = (DockableDataFactory)bundleContext.getService(dockableDataFactoryServiceReference);
        DockableDataManager dockableDataManager = dockableDataManagerProvider.getDockableDataManager();
        if (dockableDataManager.getDockableData(dockable) == null && (classDockableData = dockableDataManager.getClassDockableData(dockable)) != null) {
            DockableData copyDockableData = dockableDataFactory.copyDockableData(classDockableData);
            dockableDataManager.registerDockableData(dockable, copyDockableData);
        }
        DockingInjector dockingInjector = new DockingInjector(dockableDataManager);
        dockingInjector.inject(dockable);
        bundleContext.ungetService(dockableDataFactoryServiceReference);
        bundleContext.ungetService(dockableDataManagerProviderServiceReference);
    }
}

