/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.drombler.acp.core.action.spi.MenuEntryDescriptor;
import org.drombler.acp.core.docking.spi.DockableDataFactory;
import org.drombler.acp.core.docking.spi.DockableEntryFactory;
import org.drombler.acp.core.docking.spi.DockableFactory;
import org.drombler.acp.core.docking.spi.DockingAreaContainer;
import org.drombler.acp.core.docking.spi.DockingAreaContainerDockingAreaEvent;
import org.drombler.acp.core.docking.spi.DockingAreaContainerListener;
import org.drombler.acp.core.docking.spi.ViewDockingDescriptor;
import org.drombler.acp.core.docking.spi.impl.ActivateDockableAction;
import org.drombler.acp.core.docking.spi.impl.UnresolvedEntry;
import org.drombler.commons.client.docking.DockableData;
import org.drombler.commons.client.docking.DockableDataManager;
import org.drombler.commons.client.docking.DockableEntry;
import org.drombler.commons.client.docking.DockablePreferences;
import org.drombler.commons.client.docking.DockablePreferencesManager;
import org.drombler.commons.client.docking.DockingInjector;
import org.drombler.commons.context.ContextInjector;
import org.osgi.framework.BundleContext;

public class ViewDockingManager<D, DATA extends DockableData, E extends DockableEntry<D>>
implements AutoCloseable {
    private final Map<String, List<UnresolvedEntry<ViewDockingDescriptor>>> unresolvedDockingDescriptorsAreaId = new HashMap<String, List<UnresolvedEntry<ViewDockingDescriptor>>>();
    private final DockingAreaListener<D, E> dockingAreaListener = new DockingAreaListener();
    private final DockableFactory<D> dockableFactory;
    private final DockableDataFactory<DATA> dockableDataFactory;
    private final DockableEntryFactory<D, E> dockableEntryFactory;
    private final ContextInjector contextInjector;
    private final DockingInjector<D, DATA> dockingInjector;
    private final DockingAreaContainer<D, E> dockingAreaContainer;
    private final DockableDataManager<D, DATA> dockableDataManager;
    private final DockablePreferencesManager<D> dockablePreferencesManager;

    public ViewDockingManager(DockableFactory<D> dockableFactory, DockableDataFactory<DATA> dockableDataFactory, DockableEntryFactory<D, E> dockableEntryFactory, ContextInjector contextInjector, DockingAreaContainer<D, E> dockingAreaContainer, DockableDataManager<D, DATA> dockableDataManager, DockablePreferencesManager<D> dockablePreferencesManager) {
        this.dockableFactory = dockableFactory;
        this.dockableDataFactory = dockableDataFactory;
        this.dockableEntryFactory = dockableEntryFactory;
        this.contextInjector = contextInjector;
        this.dockingAreaContainer = dockingAreaContainer;
        this.dockableDataManager = dockableDataManager;
        this.dockingInjector = new DockingInjector(dockableDataManager);
        this.dockablePreferencesManager = dockablePreferencesManager;
        this.dockingAreaContainer.addDockingAreaContainerListener(this.dockingAreaListener);
    }

    public void addDockable(ViewDockingDescriptor dockingDescriptor, BundleContext context) {
        D dockable = this.dockableFactory.createDockable(dockingDescriptor);
        if (dockable != null) {
            DockableData dockableData = (DockableData)this.dockableDataFactory.createDockableData(dockingDescriptor);
            this.dockableDataManager.registerDockableData(dockable, dockableData);
            this.contextInjector.inject(dockable);
            this.dockingInjector.inject(dockable);
            DockablePreferences dockablePreferences = this.dockablePreferencesManager.getDockablePreferences(dockable);
            if (this.dockingAreaContainer.addDockable(this.dockableEntryFactory.createDockableEntry(dockable, dockablePreferences))) {
                dockingDescriptor.getActivateDockableActionDescriptor().setListener(new ActivateDockableAction<D>(dockable));
                context.registerService(ActionDescriptor.class, (Object)dockingDescriptor.getActivateDockableActionDescriptor(), null);
                context.registerService(MenuEntryDescriptor.class, (Object)dockingDescriptor.getActivateDockableMenuEntryDescriptor(), null);
            } else {
                if (!this.unresolvedDockingDescriptorsAreaId.containsKey(dockablePreferences.getAreaId())) {
                    this.unresolvedDockingDescriptorsAreaId.put(dockablePreferences.getAreaId(), new ArrayList());
                }
                this.unresolvedDockingDescriptorsAreaId.get(dockablePreferences.getAreaId()).add(new UnresolvedEntry<ViewDockingDescriptor>(dockingDescriptor, context));
            }
        }
    }

    private void resolveUnresolvedDockables(String areaId) {
        if (this.unresolvedDockingDescriptorsAreaId.containsKey(areaId)) {
            this.unresolvedDockingDescriptorsAreaId.get(areaId).forEach(unresolvedEntry -> this.addDockable((ViewDockingDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext()));
        }
    }

    @Override
    public void close() {
        this.dockingAreaContainer.removeDockingAreaContainerListener(this.dockingAreaListener);
    }

    private class DockingAreaListener<D, E extends DockableEntry<D>>
    implements DockingAreaContainerListener<D, E> {
        private DockingAreaListener() {
        }

        @Override
        public void dockingAreaAdded(DockingAreaContainerDockingAreaEvent<D, E> event) {
            ViewDockingManager.this.resolveUnresolvedDockables(event.getAreaId());
        }

        @Override
        public void dockingAreaRemoved(DockingAreaContainerDockingAreaEvent<D, E> event) {
        }
    }
}

