/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.drombler.acp.core.application.ApplicationExecutorProvider;
import org.drombler.acp.core.docking.jaxb.DockingsType;
import org.drombler.acp.core.docking.spi.DockableEntryFactory;
import org.drombler.acp.core.docking.spi.DockableFactory;
import org.drombler.acp.core.docking.spi.ViewDockingDescriptor;
import org.drombler.acp.core.docking.spi.impl.AbstractDockableDockingHandler;
import org.drombler.acp.core.docking.spi.impl.UnresolvedEntry;
import org.drombler.acp.core.docking.spi.impl.ViewDockingManager;
import org.drombler.commons.client.docking.DockableData;
import org.drombler.commons.client.docking.DockableEntry;
import org.drombler.commons.client.docking.DockablePreferences;
import org.drombler.commons.context.ActiveContextProvider;
import org.drombler.commons.context.ApplicationContextProvider;
import org.drombler.commons.context.ContextInjector;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewDockingHandler<D, DATA extends DockableData, E extends DockableEntry<D>>
extends AbstractDockableDockingHandler<D, DATA, E> {
    private static final Logger LOG = LoggerFactory.getLogger(ViewDockingHandler.class);
    private ActiveContextProvider activeContextProvider;
    private ApplicationContextProvider applicationContextProvider;
    private DockableFactory<D> dockableFactory;
    private DockableEntryFactory<D, E> dockableEntryFactory;
    private Executor applicationExecutor;
    private ViewDockingManager<D, DATA, E> viewDockingManager;
    private final List<UnresolvedEntry<ViewDockingDescriptor>> unresolvedDockingDescriptors = new ArrayList<UnresolvedEntry<ViewDockingDescriptor>>();

    protected void bindActiveContextProvider(ActiveContextProvider activeContextProvider) {
        this.activeContextProvider = activeContextProvider;
    }

    protected void unbindActiveContextProvider(ActiveContextProvider activeContextProvider) {
        this.activeContextProvider = null;
    }

    protected void bindApplicationContextProvider(ApplicationContextProvider applicationContextProvider) {
        this.applicationContextProvider = applicationContextProvider;
    }

    protected void unbindApplicationContextProvider(ApplicationContextProvider applicationContextProvider) {
        this.applicationContextProvider = null;
    }

    protected void bindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = applicationExecutorProvider.getApplicationExecutor();
    }

    protected void unbindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = null;
    }

    protected void bindDockableFactory(DockableFactory<D> dockableFactory) {
        this.dockableFactory = dockableFactory;
    }

    protected void unbindDockableFactory(DockableFactory<D> dockableFactory) {
        this.dockableFactory = null;
    }

    protected void bindDockableEntryFactory(DockableEntryFactory<D, E> dockableEntryFactory) {
        this.dockableEntryFactory = dockableEntryFactory;
    }

    protected void unbindDockableEntryFactory(DockableEntryFactory<D, E> dockableEntryFactory) {
        this.dockableEntryFactory = null;
    }

    protected void bindViewDockingDescriptor(ServiceReference<ViewDockingDescriptor> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        ViewDockingDescriptor dockingDescriptor = (ViewDockingDescriptor)context.getService(serviceReference);
        this.resolveDockable(dockingDescriptor, context);
    }

    protected void unbindViewDockingDescriptor(ViewDockingDescriptor dockingDescriptor) {
    }

    protected void activate(ComponentContext context) {
        this.viewDockingManager = new ViewDockingManager(this.dockableFactory, this.getDockableDataFactory(), this.dockableEntryFactory, new ContextInjector(this.activeContextProvider, this.applicationContextProvider), this.getDockingAreaContainerProvider().getDockingAreaContainer(), this.getDockableDataManager(), this.getDockablePreferencesManager());
        this.resolveUnresolvedDockables();
    }

    protected void deactivate(ComponentContext context) {
        this.viewDockingManager.close();
        this.viewDockingManager = null;
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.dockableFactory != null && this.dockableEntryFactory != null && this.applicationExecutor != null && this.activeContextProvider != null && this.applicationContextProvider != null;
    }

    @Override
    protected void resolveDockingsType(DockingsType dockingsType, Bundle bundle, BundleContext context) {
        dockingsType.getViewDocking().forEach(dockingType -> {
            try {
                ViewDockingDescriptor dockingDescriptor = ViewDockingDescriptor.createViewDockingDescriptor(dockingType, bundle);
                this.resolveDockable(dockingDescriptor, context);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        });
    }

    private void resolveDockable(ViewDockingDescriptor dockingDescriptor, BundleContext context) {
        if (this.isInitialized()) {
            this.resolveDockableBasic(dockingDescriptor);
            this.addDockable(dockingDescriptor, context);
        } else {
            this.unresolvedDockingDescriptors.add(new UnresolvedEntry<ViewDockingDescriptor>(dockingDescriptor, context));
        }
    }

    private void resolveDockableBasic(ViewDockingDescriptor dockingDescriptor) {
        this.registerDefaultDockablePreferences(dockingDescriptor);
    }

    private void addDockable(ViewDockingDescriptor dockingDescriptor, BundleContext context) {
        this.applicationExecutor.execute(() -> this.viewDockingManager.addDockable(dockingDescriptor, context));
    }

    private void addDockables(List<UnresolvedEntry<ViewDockingDescriptor>> unresolvedDockingDescriptors) {
        this.applicationExecutor.execute(() -> unresolvedDockingDescriptors.forEach(unresolvedEntry -> this.viewDockingManager.addDockable((ViewDockingDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext())));
    }

    private void registerDefaultDockablePreferences(ViewDockingDescriptor dockingDescriptor) {
        DockablePreferences dockablePreferences = this.createDockablePreferences(dockingDescriptor.getAreaId(), dockingDescriptor.getPosition());
        this.registerDefaultDockablePreferences(dockingDescriptor.getDockableClass(), dockablePreferences);
    }

    private void registerDefaultDockablePreferences(List<UnresolvedEntry<ViewDockingDescriptor>> unresolvedDockingDescriptors) {
        unresolvedDockingDescriptors.forEach(unresolvedEntry -> this.resolveDockableBasic((ViewDockingDescriptor)unresolvedEntry.getEntry()));
    }

    private void resolveUnresolvedDockables() {
        if (this.isInitialized()) {
            ArrayList<UnresolvedEntry<ViewDockingDescriptor>> unresolvedDockingDescriptorsCopy = new ArrayList<UnresolvedEntry<ViewDockingDescriptor>>(this.unresolvedDockingDescriptors);
            this.unresolvedDockingDescriptors.clear();
            this.registerDefaultDockablePreferences(unresolvedDockingDescriptorsCopy);
            this.addDockables(unresolvedDockingDescriptorsCopy);
        }
    }
}

