/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.docking.spi.impl;

import java.util.ArrayList;
import java.util.List;
import org.drombler.acp.core.docking.jaxb.DockingsType;
import org.drombler.acp.core.docking.spi.EditorDockingDescriptor;
import org.drombler.acp.core.docking.spi.impl.AbstractDockableDockingHandler;
import org.drombler.commons.client.docking.DockableData;
import org.drombler.commons.client.docking.DockableEntry;
import org.drombler.commons.client.docking.DockablePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorDockingHandler<D, DATA extends DockableData, E extends DockableEntry<D>>
extends AbstractDockableDockingHandler<D, DATA, E> {
    private static final Logger LOG = LoggerFactory.getLogger(EditorDockingHandler.class);
    private final List<EditorDockingDescriptor> unresolvedDockingDescriptors = new ArrayList<EditorDockingDescriptor>();

    protected void bindEditorDockingDescriptor(EditorDockingDescriptor dockingDescriptor) {
        this.resolveDockingDescriptor(dockingDescriptor);
    }

    protected void unbindEditorDockingDescriptor(EditorDockingDescriptor dockingDescriptor) {
    }

    protected void activate(ComponentContext context) {
        this.resolveUnresolvedDockables();
    }

    protected void deactivate(ComponentContext context) {
    }

    @Override
    protected void resolveDockingsType(DockingsType dockingsType, Bundle bundle, BundleContext context) {
        dockingsType.getEditorDocking().forEach(dockingType -> {
            try {
                EditorDockingDescriptor dockingDescriptor = EditorDockingDescriptor.createEditorDockingDescriptor(dockingType, bundle);
                this.resolveDockingDescriptor(dockingDescriptor);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        });
    }

    private void resolveDockingDescriptor(EditorDockingDescriptor dockingDescriptor) {
        if (this.isInitialized()) {
            DockableData dockableData = (DockableData)this.getDockableDataFactory().createDockableData(dockingDescriptor);
            this.registerClassDockableData(dockingDescriptor.getDockableClass(), dockableData);
            DockablePreferences dockablePreferences = this.createDockablePreferences(dockingDescriptor.getAreaId(), 0);
            this.registerDefaultDockablePreferences(dockingDescriptor.getDockableClass(), dockablePreferences);
        } else {
            this.unresolvedDockingDescriptors.add(dockingDescriptor);
        }
    }

    private void resolveUnresolvedDockables() {
        this.unresolvedDockingDescriptors.forEach(unresolvedDockingDescriptor -> this.resolveDockingDescriptor((EditorDockingDescriptor)unresolvedDockingDescriptor));
    }
}

