/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.drombler.acp.core.data.jaxb.FileExtensionType;
import org.drombler.acp.core.data.jaxb.FileExtensionsType;
import org.drombler.acp.core.data.spi.FileExtensionDescriptorRegistryProvider;
import org.drombler.acp.core.data.spi.impl.FileExtensionUtils;
import org.drombler.commons.data.file.FileExtensionDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@References(value={@Reference(name="fileExtensionsType", referenceInterface=FileExtensionsType.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="fileExtensionDescriptor", referenceInterface=FileExtensionDescriptor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class FileExtensionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FileExtensionHandler.class);
    private final List<FileExtensionDescriptor> unresolvedFileExtensionDescriptors = new ArrayList<FileExtensionDescriptor>();
    @Reference
    private FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider;

    protected void bindFileExtensionsType(ServiceReference<FileExtensionsType> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        FileExtensionsType fileExtensionsType = (FileExtensionsType)context.getService(serviceReference);
        this.registerFileExtensions(fileExtensionsType, context);
    }

    protected void unbindFileExtensionsType(FileExtensionsType fileExtensionsType) {
    }

    protected void bindFileExtensionDescriptor(FileExtensionDescriptor fileExtensionDescriptor) {
        this.registerFileExtensionDescriptor(fileExtensionDescriptor);
    }

    protected void unbindFileExtensionDescriptor(FileExtensionDescriptor fileExtensionDescriptor) {
    }

    protected void bindFileExtensionDescriptorRegistryProvider(FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider) {
        this.fileExtensionDescriptorRegistryProvider = fileExtensionDescriptorRegistryProvider;
    }

    protected void unbindFileExtensionDescriptorRegistryProvider(FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider) {
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resolveUnresolvedFileExtensionDescriptors();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    private void registerFileExtensions(FileExtensionsType fileExtensionsType, BundleContext context) {
        fileExtensionsType.getFileExtension().forEach(fileExtensionType -> this.registerFileExtension((FileExtensionType)fileExtensionType, context));
    }

    private void registerFileExtension(FileExtensionType fileExtensionType, BundleContext context) {
        FileExtensionDescriptor fileExtensionDescriptor = FileExtensionUtils.createFileExtensionDescriptor(fileExtensionType, context.getBundle());
        this.registerFileExtensionDescriptor(fileExtensionDescriptor);
    }

    private void registerFileExtensionDescriptor(FileExtensionDescriptor fileExtensionDescriptor) {
        if (this.isInitialized()) {
            this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry().registerFileExtensionDescriptor(fileExtensionDescriptor);
        } else {
            this.unresolvedFileExtensionDescriptors.add(fileExtensionDescriptor);
        }
    }

    private void resolveUnresolvedFileExtensionDescriptors() {
        this.unresolvedFileExtensionDescriptors.forEach(this::registerFileExtensionDescriptor);
    }

    private boolean isInitialized() {
        return this.fileExtensionDescriptorRegistryProvider != null;
    }
}

