/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.commons.util.BundleUtils;
import org.drombler.acp.core.data.jaxb.BusinessObjectHandlerType;
import org.drombler.acp.core.data.jaxb.DataHandlerType;
import org.drombler.acp.core.data.jaxb.DocumentHandlerType;
import org.drombler.commons.data.AbstractDataHandlerDescriptor;
import org.drombler.commons.data.BusinessObjectHandlerDescriptor;
import org.drombler.commons.data.file.DocumentHandlerDescriptor;
import org.osgi.framework.Bundle;
import org.softsmithy.lib.util.ResourceLoader;

public final class DataHandlerUtils {
    private DataHandlerUtils() {
    }

    public static DocumentHandlerDescriptor<?> createDocumentHandlerDescriptor(DocumentHandlerType documentHandler, Bundle bundle) throws ClassNotFoundException {
        Class handlerClass = BundleUtils.loadClass((Bundle)bundle, (String)documentHandler.getHandlerClass());
        return DataHandlerUtils.createDocumentHandlerDescriptor(documentHandler, handlerClass);
    }

    private static <D> DocumentHandlerDescriptor<D> createDocumentHandlerDescriptor(DocumentHandlerType documentHandler, Class<D> handlerClass) throws ClassNotFoundException {
        DocumentHandlerDescriptor documentHandlerDescriptor = new DocumentHandlerDescriptor();
        documentHandlerDescriptor.setMimeType(StringUtils.stripToNull((String)documentHandler.getMimeType()));
        DataHandlerUtils.configureDataHandlerDescriptor(documentHandlerDescriptor, (DataHandlerType)documentHandler, handlerClass);
        return documentHandlerDescriptor;
    }

    private static <D> void configureDataHandlerDescriptor(AbstractDataHandlerDescriptor<D> descriptor, DataHandlerType dataHandlerType, Class<D> handlerClass) {
        descriptor.setIcon(StringUtils.stripToNull((String)dataHandlerType.getIcon()));
        descriptor.setResourceLoader(new ResourceLoader(handlerClass));
        descriptor.setDataHandlerClass(handlerClass);
    }

    public static BusinessObjectHandlerDescriptor<?> createBusinessObjectHandlerDescriptor(BusinessObjectHandlerType businessObjectHandler, Bundle bundle) throws ClassNotFoundException {
        Class handlerClass = BundleUtils.loadClass((Bundle)bundle, (String)businessObjectHandler.getHandlerClass());
        return DataHandlerUtils.createBusinessObjectHandlerDescriptor(businessObjectHandler, handlerClass);
    }

    private static <D> BusinessObjectHandlerDescriptor<D> createBusinessObjectHandlerDescriptor(BusinessObjectHandlerType businessObjectHandler, Class<D> handlerClass) {
        BusinessObjectHandlerDescriptor descriptor = new BusinessObjectHandlerDescriptor();
        DataHandlerUtils.configureDataHandlerDescriptor(descriptor, (DataHandlerType)businessObjectHandler, handlerClass);
        return descriptor;
    }
}

