/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.drombler.acp.core.data.jaxb.DataHandlersType;
import org.drombler.acp.core.data.spi.DataHandlerDescriptorRegistryProvider;
import org.drombler.commons.data.AbstractDataHandlerDescriptor;
import org.drombler.commons.data.DataHandlerDescriptorRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@References(value={@Reference(name="dataHandlersType", referenceInterface=DataHandlersType.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public abstract class AbstractDataHandlerHandler<D extends AbstractDataHandlerDescriptor<?>> {
    private final List<D> unresolvedDataHandlerDescriptors = new ArrayList<D>();
    @Reference
    private DataHandlerDescriptorRegistryProvider dataHandlerDescriptorRegistryProvider;

    protected void bindDataHandlersType(ServiceReference<DataHandlersType> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        DataHandlersType dataHandlersType = (DataHandlersType)context.getService(serviceReference);
        this.registerDataHandlers(dataHandlersType, context);
    }

    protected void unbindDataHandlersType(DataHandlersType documentHandlersType) {
    }

    protected void bindDataHandlerDescriptorRegistryProvider(DataHandlerDescriptorRegistryProvider dataHandlerDescriptorRegistryProvider) {
        this.dataHandlerDescriptorRegistryProvider = dataHandlerDescriptorRegistryProvider;
    }

    protected void unbindDataHandlerDescriptorRegistryProvider(DataHandlerDescriptorRegistryProvider dataHandlerDescriptorRegistryProvider) {
        this.dataHandlerDescriptorRegistryProvider = null;
    }

    protected void activate(ComponentContext context) {
        this.resolveUnresolvedDocumentHandlerDescriptors();
    }

    protected void deactivate(ComponentContext context) {
    }

    protected abstract void registerDataHandlers(DataHandlersType var1, BundleContext var2);

    public DataHandlerDescriptorRegistry getDataHandlerDescriptorRegistry() {
        return this.dataHandlerDescriptorRegistryProvider.getDataHandlerDescriptorRegistry();
    }

    private void resolveUnresolvedDocumentHandlerDescriptors() {
        this.unresolvedDataHandlerDescriptors.forEach(this::resolveDataHandlerDescriptor);
    }

    protected void resolveDataHandlerDescriptor(D handlerDescriptor) {
        if (this.isInitialized()) {
            this.resolveDataHandlerDescriptorInitialized(handlerDescriptor);
        } else {
            this.unresolvedDataHandlerDescriptors.add(handlerDescriptor);
        }
    }

    protected boolean isInitialized() {
        return this.dataHandlerDescriptorRegistryProvider != null;
    }

    protected void resolveDataHandlerDescriptorInitialized(D handlerDescriptor) {
        this.getDataHandlerDescriptorRegistry().registerDataHandlerDescriptor(handlerDescriptor);
    }
}

