/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.drombler.acp.core.data.jaxb.DataHandlersType;
import org.drombler.acp.core.data.jaxb.DocumentHandlerType;
import org.drombler.acp.core.data.spi.DocumentHandlerDescriptorRegistryProvider;
import org.drombler.acp.core.data.spi.impl.AbstractDataHandlerHandler;
import org.drombler.acp.core.data.spi.impl.DataHandlerUtils;
import org.drombler.commons.data.file.DocumentHandlerDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@References(value={@Reference(name="documentHandlerDescriptor", referenceInterface=DocumentHandlerDescriptor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class DocumentHandlerHandler
extends AbstractDataHandlerHandler<DocumentHandlerDescriptor<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentHandlerHandler.class);
    @Reference
    private DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider;

    protected void bindDocumentHandlerDescriptor(DocumentHandlerDescriptor<?> handlerDescriptor) {
        this.resolveDataHandlerDescriptor(handlerDescriptor);
    }

    protected void unbindDocumentHandlerDescriptor(DocumentHandlerDescriptor<?> handlerDescriptor) {
    }

    protected void bindDocumentHandlerDescriptorRegistryProvider(DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider) {
        this.documentHandlerDescriptorRegistryProvider = documentHandlerDescriptorRegistryProvider;
    }

    protected void unbindDocumentHandlerDescriptorRegistryProvider(DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider) {
        this.documentHandlerDescriptorRegistryProvider = null;
    }

    @Override
    @Activate
    protected void activate(ComponentContext context) {
        super.activate(context);
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    @Override
    protected void registerDataHandlers(DataHandlersType dataHandlersType, BundleContext context) {
        dataHandlersType.getDocumentHandler().forEach(documentHandlerType -> this.registerDocumentHandler((DocumentHandlerType)documentHandlerType, context));
    }

    private void registerDocumentHandler(DocumentHandlerType documentHandlerType, BundleContext context) {
        try {
            DocumentHandlerDescriptor<?> documentHandlerDescriptor = DataHandlerUtils.createDocumentHandlerDescriptor(documentHandlerType, context.getBundle());
            this.resolveDataHandlerDescriptor(documentHandlerDescriptor);
        }
        catch (ClassNotFoundException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.documentHandlerDescriptorRegistryProvider != null;
    }

    @Override
    protected void resolveDataHandlerDescriptorInitialized(DocumentHandlerDescriptor<?> handlerDescriptor) {
        super.resolveDataHandlerDescriptorInitialized(handlerDescriptor);
        this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry().registerDocumentHandlerDescriptor(handlerDescriptor);
    }
}

