/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.drombler.acp.core.data.spi.DocumentHandlerDescriptorRegistryProvider;
import org.drombler.acp.core.data.spi.FileExtensionDescriptorRegistryProvider;
import org.drombler.acp.startup.main.AdditionalArgumentsProvider;
import org.drombler.commons.data.file.DocumentHandlerDescriptor;
import org.drombler.commons.data.file.DocumentHandlerDescriptorRegistry;
import org.drombler.commons.data.file.FileExtensionDescriptor;
import org.drombler.commons.data.file.FileExtensionDescriptorRegistry;
import org.drombler.commons.data.file.FileUtils;
import org.osgi.service.component.ComponentContext;
import org.softsmithy.lib.util.SetChangeEvent;
import org.softsmithy.lib.util.SetChangeListener;

@Component(immediate=true)
@Reference(name="additionalArgumentsProvider", referenceInterface=AdditionalArgumentsProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class AdditionalFileParamsHandler {
    @Reference
    private FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider;
    @Reference
    private DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider;
    private final List<String> unresolvedArguments = new ArrayList<String>();
    private final List<Path> unresolvedPaths = new ArrayList<Path>();
    private final SetChangeListener<FileExtensionDescriptor> openFileListener = new OpenFileListener();
    private final SetChangeListener<DocumentHandlerDescriptor<?>> openDocumentListener = new OpenDocumentListener();

    protected void bindAdditionalArgumentsProvider(AdditionalArgumentsProvider additionalArgumentsProvider) {
        this.handleAdditionalArguments(additionalArgumentsProvider.getAdditionalArguments());
    }

    protected void unbindAdditionalArgumentsProvider(AdditionalArgumentsProvider additionalArgumentsProvider) {
    }

    protected void bindFileExtensionDescriptorRegistryProvider(FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider) {
        this.fileExtensionDescriptorRegistryProvider = fileExtensionDescriptorRegistryProvider;
    }

    protected void unbindFileExtensionDescriptorRegistryProvider(FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistry) {
    }

    protected void bindDocumentHandlerDescriptorRegistryProvider(DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider) {
        this.documentHandlerDescriptorRegistryProvider = documentHandlerDescriptorRegistryProvider;
    }

    protected void unbindDocumentHandlerDescriptorRegistryProvider(DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider) {
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry().addFileExtensionListener(this.openFileListener);
        this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry().addDocumentHandlerDescriptorListener(this.openDocumentListener);
        this.resolveUnresolvedArguments();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry().removeDocumentHandlerDescriptorListener(this.openDocumentListener);
        this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry().removeFileExtensionListener(this.openFileListener);
    }

    private boolean isInitialized() {
        return this.fileExtensionDescriptorRegistryProvider != null && this.documentHandlerDescriptorRegistryProvider != null;
    }

    private void handleAdditionalArguments(List<String> additionalArguments) {
        if (this.isInitialized()) {
            additionalArguments.stream().map(this::toPath).filter(Optional::isPresent).map(Optional::get).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this::openFile);
        } else {
            this.unresolvedArguments.addAll(additionalArguments);
        }
    }

    private Optional<Path> toPath(String pathString) {
        try {
            return Optional.of(Paths.get(pathString, new String[0]));
        }
        catch (InvalidPathException ex1) {
            try {
                URI uri = new URI(pathString);
                return Optional.of(Paths.get(uri));
            }
            catch (IllegalArgumentException | NullPointerException | SecurityException | URISyntaxException | FileSystemNotFoundException ex2) {
                return Optional.empty();
            }
        }
    }

    private void openFile(Path filePath) {
        try {
            FileUtils.openFile((Path)filePath, (FileExtensionDescriptorRegistry)this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry(), (DocumentHandlerDescriptorRegistry)this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry());
        }
        catch (RuntimeException ex) {
            this.unresolvedPaths.add(filePath);
        }
    }

    private void resolveUnresolvedArguments() {
        ArrayList<String> unresolvedArgumentsCopy = new ArrayList<String>(this.unresolvedArguments);
        this.unresolvedArguments.clear();
        this.handleAdditionalArguments(unresolvedArgumentsCopy);
    }

    private void resolveUnresolvedPaths() {
        ArrayList<Path> unresolvedPathsCopy = new ArrayList<Path>(this.unresolvedPaths);
        this.unresolvedPaths.clear();
        unresolvedPathsCopy.forEach(this::openFile);
    }

    private class OpenDocumentListener
    implements SetChangeListener<DocumentHandlerDescriptor<?>> {
        private OpenDocumentListener() {
        }

        public void elementAdded(SetChangeEvent<DocumentHandlerDescriptor<?>> event) {
            AdditionalFileParamsHandler.this.resolveUnresolvedPaths();
        }

        public void elementRemoved(SetChangeEvent<DocumentHandlerDescriptor<?>> event) {
        }
    }

    private class OpenFileListener
    implements SetChangeListener<FileExtensionDescriptor> {
        private OpenFileListener() {
        }

        public void elementAdded(SetChangeEvent<FileExtensionDescriptor> event) {
            AdditionalFileParamsHandler.this.resolveUnresolvedPaths();
        }

        public void elementRemoved(SetChangeEvent<FileExtensionDescriptor> event) {
        }
    }
}

