/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.drombler.acp.core.context.ContextManagerProvider;
import org.drombler.acp.core.data.spi.DataHandlerRegistryProvider;
import org.drombler.acp.core.data.spi.DocumentHandlerDescriptorRegistryProvider;
import org.drombler.acp.core.data.spi.FileExtensionDescriptorRegistryProvider;
import org.drombler.acp.startup.main.AdditionalArgumentsProvider;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.drombler.commons.data.DataHandlerRegistry;
import org.drombler.commons.data.file.DocumentHandlerDescriptor;
import org.drombler.commons.data.file.DocumentHandlerDescriptorRegistry;
import org.drombler.commons.data.file.FileExtensionDescriptor;
import org.drombler.commons.data.file.FileExtensionDescriptorRegistry;
import org.drombler.commons.data.file.FileUtils;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.softsmithy.lib.util.SetChangeEvent;
import org.softsmithy.lib.util.SetChangeListener;

@Component(immediate=true)
public class AdditionalFileParamsHandler {
    @Reference
    private FileExtensionDescriptorRegistryProvider fileExtensionDescriptorRegistryProvider;
    @Reference
    private DocumentHandlerDescriptorRegistryProvider documentHandlerDescriptorRegistryProvider;
    @Reference
    private DataHandlerRegistryProvider dataHandlerRegistryProvider;
    @Reference
    private ContextManagerProvider contextManagerProvider;
    private ContextInjector contextInjector;
    private final List<String> unresolvedArguments = new ArrayList<String>();
    private final List<Path> unresolvedPaths = new ArrayList<Path>();
    private final SetChangeListener<FileExtensionDescriptor> openFileListener = new OpenFileListener();
    private final SetChangeListener<DocumentHandlerDescriptor<?>> openDocumentListener = new OpenDocumentListener();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindAdditionalArgumentsProvider(AdditionalArgumentsProvider additionalArgumentsProvider) {
        this.handleAdditionalArguments(additionalArgumentsProvider.getAdditionalArguments());
    }

    protected void unbindAdditionalArgumentsProvider(AdditionalArgumentsProvider additionalArgumentsProvider) {
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.contextInjector = new ContextInjector(this.contextManagerProvider.getContextManager());
        this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry().addFileExtensionListener(this.openFileListener);
        this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry().addDocumentHandlerDescriptorListener(this.openDocumentListener);
        this.resolveUnresolvedArguments();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry().removeDocumentHandlerDescriptorListener(this.openDocumentListener);
        this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry().removeFileExtensionListener(this.openFileListener);
        this.contextInjector = null;
    }

    private boolean isInitialized() {
        return this.fileExtensionDescriptorRegistryProvider != null && this.documentHandlerDescriptorRegistryProvider != null && this.dataHandlerRegistryProvider != null && this.contextManagerProvider != null && this.contextInjector != null;
    }

    private void handleAdditionalArguments(List<String> additionalArguments) {
        if (this.isInitialized()) {
            additionalArguments.stream().map(this::toPath).filter(Optional::isPresent).map(Optional::get).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(this::openFile);
        } else {
            this.unresolvedArguments.addAll(additionalArguments);
        }
    }

    private Optional<Path> toPath(String pathString) {
        try {
            return Optional.of(Paths.get(pathString, new String[0]));
        }
        catch (InvalidPathException ex1) {
            try {
                URI uri = new URI(pathString);
                return Optional.of(Paths.get(uri));
            }
            catch (IllegalArgumentException | NullPointerException | SecurityException | URISyntaxException | FileSystemNotFoundException ex2) {
                return Optional.empty();
            }
        }
    }

    private void openFile(Path filePath) {
        try {
            FileUtils.openFile((Path)filePath, (DataHandlerRegistry)this.dataHandlerRegistryProvider.getDataHandlerRegistry(), (FileExtensionDescriptorRegistry)this.fileExtensionDescriptorRegistryProvider.getFileExtensionDescriptorRegistry(), (DocumentHandlerDescriptorRegistry)this.documentHandlerDescriptorRegistryProvider.getDocumentHandlerDescriptorRegistry(), (ContextManager)this.contextManagerProvider.getContextManager(), (ContextInjector)this.contextInjector);
        }
        catch (RuntimeException ex) {
            this.unresolvedPaths.add(filePath);
        }
    }

    private void resolveUnresolvedArguments() {
        ArrayList<String> unresolvedArgumentsCopy = new ArrayList<String>(this.unresolvedArguments);
        this.unresolvedArguments.clear();
        this.handleAdditionalArguments(unresolvedArgumentsCopy);
    }

    private void resolveUnresolvedPaths() {
        ArrayList<Path> unresolvedPathsCopy = new ArrayList<Path>(this.unresolvedPaths);
        this.unresolvedPaths.clear();
        unresolvedPathsCopy.forEach(this::openFile);
    }

    private class OpenDocumentListener
    implements SetChangeListener<DocumentHandlerDescriptor<?>> {
        private OpenDocumentListener() {
        }

        public void elementAdded(SetChangeEvent<DocumentHandlerDescriptor<?>> event) {
            AdditionalFileParamsHandler.this.resolveUnresolvedPaths();
        }

        public void elementRemoved(SetChangeEvent<DocumentHandlerDescriptor<?>> event) {
        }
    }

    private class OpenFileListener
    implements SetChangeListener<FileExtensionDescriptor> {
        private OpenFileListener() {
        }

        public void elementAdded(SetChangeEvent<FileExtensionDescriptor> event) {
            AdditionalFileParamsHandler.this.resolveUnresolvedPaths();
        }

        public void elementRemoved(SetChangeEvent<FileExtensionDescriptor> event) {
        }
    }
}

