/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.data.spi.impl;

import org.drombler.acp.core.data.jaxb.BusinessObjectHandlerType;
import org.drombler.acp.core.data.jaxb.DataHandlersType;
import org.drombler.acp.core.data.spi.impl.AbstractDataHandlerHandler;
import org.drombler.acp.core.data.spi.impl.DataHandlerUtils;
import org.drombler.commons.data.BusinessObjectHandlerDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BusinessObjectHandlerHandler
extends AbstractDataHandlerHandler<BusinessObjectHandlerDescriptor<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(BusinessObjectHandlerHandler.class);

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindBusinessObjectHandlerDescriptor(BusinessObjectHandlerDescriptor<?> handlerDescriptor) {
        this.resolveDataHandlerDescriptor(handlerDescriptor);
    }

    protected void unbindBusinessObjectHandlerDescriptor(BusinessObjectHandlerDescriptor<?> handlerDescriptor) {
    }

    @Override
    @Activate
    protected void activate(ComponentContext context) {
        super.activate(context);
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    @Override
    protected void registerDataHandlers(DataHandlersType dataHandlersType, BundleContext context) {
        dataHandlersType.getBusinessObjectHandler().forEach(businessObjectHandler -> this.registerBusinessObjectHandler((BusinessObjectHandlerType)businessObjectHandler, context));
    }

    private void registerBusinessObjectHandler(BusinessObjectHandlerType businessObjectHandler, BundleContext context) {
        try {
            BusinessObjectHandlerDescriptor<?> businessObjectHandlerDescriptor = DataHandlerUtils.createBusinessObjectHandlerDescriptor(businessObjectHandler, context.getBundle());
            this.resolveDataHandlerDescriptor(businessObjectHandlerDescriptor);
        }
        catch (ClassNotFoundException | RuntimeException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

