/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.commons.util.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drombler.acp.core.commons.util.context.AbstractContext;

public class SimpleContext
extends AbstractContext {
    private final Map<Class<?>, List<Object>> objects = new HashMap();

    @Override
    public <T> T find(Class<T> type) {
        List<Object> objs;
        if (this.objects.containsKey(type) && !(objs = this.objects.get(type)).isEmpty()) {
            return type.cast(objs.get(0));
        }
        return null;
    }

    @Override
    public <T> Collection<? extends T> findAll(Class<T> type) {
        if (this.objects.containsKey(type)) {
            return Collections.unmodifiableList(this.objects.get(type));
        }
        return Collections.emptyList();
    }

    public void add(Object obj) {
        Set<Class<?>> types = this.getTypes(obj);
        for (Class<?> type : types) {
            this.add(type, obj);
        }
        for (Class<?> type : types) {
            this.fireContextEvent(type);
        }
    }

    private void add(Class<?> type, Object obj) {
        if (!this.objects.containsKey(type)) {
            this.objects.put(type, new ArrayList());
        }
        this.objects.get(type).add(obj);
    }

    private Set<Class<?>> getTypes(Object obj) {
        HashSet types = new HashSet();
        for (Class<?> type = obj.getClass(); type != null; type = type.getSuperclass()) {
            types.add(type);
            types.addAll(Arrays.asList(type.getInterfaces()));
        }
        return types;
    }

    public void remove(Object obj) {
        if (obj != null) {
            Set<Class<?>> types = this.getTypes(obj);
            for (Class<?> type : types) {
                this.remove(type, obj);
            }
            for (Class<?> type : types) {
                this.fireContextEvent(type);
            }
        }
    }

    private void remove(Class<?> type, Object obj) {
        if (this.objects.containsKey(type)) {
            this.objects.get(type).remove(obj);
        }
    }
}

