/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.commons.util.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drombler.acp.core.commons.util.context.AbstractContext;
import org.drombler.acp.core.commons.util.context.Context;
import org.drombler.acp.core.commons.util.context.ContextListener;

public class ProxyContext
extends AbstractContext {
    private final List<Context> contexts = new ArrayList<Context>();

    @Override
    public <T> T find(Class<T> type) {
        for (Context context : this.contexts) {
            T result = context.find(type);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public <T> Collection<? extends T> findAll(Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Context context : this.contexts) {
            result.addAll(context.findAll(type));
        }
        return result;
    }

    @Override
    public void addContextListener(Class<?> type, ContextListener listener) {
        super.addContextListener(type, listener);
        for (Context context : this.contexts) {
            context.addContextListener(type, listener);
        }
    }

    @Override
    public void removeContextListener(Class<?> type, ContextListener listener) {
        super.removeContextListener(type, listener);
        for (Context context : this.contexts) {
            context.removeContextListener(type, listener);
        }
    }

    public void addContext(Context context) {
        this.addContextOnly(context);
        this.fireContextEvents(Arrays.asList(context));
    }

    private void addContextOnly(Context context) {
        this.contexts.add(context);
        for (Map.Entry<Class<?>, List<ContextListener>> entry : this.getListeners().entrySet()) {
            for (ContextListener contextListener : entry.getValue()) {
                context.addContextListener(entry.getKey(), contextListener);
            }
        }
    }

    public void removeContext(Context context) {
        this.removeContextOnly(context);
        this.fireContextEvents(Arrays.asList(context));
    }

    private void removeContextOnly(Context context) {
        this.contexts.remove(context);
        for (Map.Entry<Class<?>, List<ContextListener>> entry : this.getListeners().entrySet()) {
            for (ContextListener contextListener : entry.getValue()) {
                context.removeContextListener(entry.getKey(), contextListener);
            }
        }
    }

    public void setContexts(Context ... contexts) {
        this.setContexts(Arrays.asList(contexts));
    }

    public void setContexts(List<? extends Context> contexts) {
        ArrayList<Context> contextsToRemove = new ArrayList<Context>(this.contexts);
        contextsToRemove.removeAll(contexts);
        for (Context context : contextsToRemove) {
            this.removeContextOnly(context);
        }
        ArrayList<? extends Context> contextsToAdd = new ArrayList<Context>(contexts);
        contextsToAdd.removeAll(this.contexts);
        for (Context context : contexts) {
            this.addContextOnly(context);
        }
        ArrayList<Context> changedContexts = new ArrayList<Context>(contextsToRemove);
        changedContexts.addAll(contextsToAdd);
        this.fireContextEvents(changedContexts);
    }

    private void fireContextEvents(List<Context> changedContexts) {
        block0: for (Class<?> type : this.getListeners().keySet()) {
            for (Context context : changedContexts) {
                if (context.findAll(type).isEmpty()) continue;
                this.fireContextEvent(type);
                continue block0;
            }
        }
    }
}

