/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.commons.util.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drombler.acp.core.commons.util.context.Context;
import org.drombler.acp.core.commons.util.context.ContextEvent;
import org.drombler.acp.core.commons.util.context.ContextListener;

public abstract class AbstractContext
implements Context {
    private final Map<Class<?>, List<ContextListener>> listeners = new HashMap();

    @Override
    public void addContextListener(Class<?> type, ContextListener listener) {
        if (!this.listeners.containsKey(type)) {
            this.getListeners().put(type, new ArrayList());
        }
        this.getListeners().get(type).add(listener);
    }

    @Override
    public void removeContextListener(Class<?> type, ContextListener listener) {
        if (this.getListeners().containsKey(type)) {
            this.getListeners().get(type).remove(listener);
        }
    }

    protected void fireContextEvent(Class<?> type) {
        if (this.getListeners().containsKey(type)) {
            ContextEvent event = new ContextEvent(this);
            for (ContextListener listener : this.getListeners().get(type)) {
                listener.contextChanged(event);
            }
        }
    }

    protected Map<Class<?>, List<ContextListener>> getListeners() {
        return this.listeners;
    }
}

