/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.commons.util;

import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.commons.util.BundleProxyClassLoader;
import org.osgi.framework.Bundle;

public class Resources {
    public static final String PROPERTIES_FILE_BASE_NAME = "Bundle";
    public static final String KEY_PREFIX = "%";

    private Resources() {
    }

    public static ResourceBundle getResourceBundle(Class<?> type) {
        return Resources.getResourceBundle(type, PROPERTIES_FILE_BASE_NAME);
    }

    public static ResourceBundle getResourceBundle(Class<?> type, String baseName) {
        return Resources.getResourceBundle(type.getPackage().getName(), baseName, type.getClassLoader());
    }

    public static ResourceBundle getResourceBundle(String aPackage, ClassLoader classLoader) {
        return Resources.getResourceBundle(aPackage, PROPERTIES_FILE_BASE_NAME, classLoader);
    }

    public static ResourceBundle getResourceBundle(String aPackage, String baseName, ClassLoader classLoader) {
        return ResourceBundle.getBundle(aPackage + "." + baseName, Locale.getDefault(), classLoader);
    }

    public static String getResourceString(Class<?> type, String resourceKey) {
        return Resources.getResourceString(type.getPackage().getName(), resourceKey, type.getClassLoader());
    }

    public static String getResourceString(String aPackage, String resourceKey, Bundle bundle) {
        return Resources.getResourceString(aPackage, resourceKey, new BundleProxyClassLoader(bundle));
    }

    private static String getResourceString(String aPackage, String resourceKey, ClassLoader classLoader) {
        String strippedResourceKey = StringUtils.stripToNull((String)resourceKey);
        if (strippedResourceKey != null && strippedResourceKey.startsWith(KEY_PREFIX)) {
            strippedResourceKey = strippedResourceKey.substring(1);
            ResourceBundle rb = Resources.getResourceBundle(aPackage, classLoader);
            return rb.getString(strippedResourceKey);
        }
        return resourceKey;
    }
}

