/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.application.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.drombler.acp.core.application.AbstractApplicationAnnotationProcessor;
import org.drombler.acp.core.application.Extension;
import org.drombler.acp.core.application.Extensions;

@SupportedAnnotationTypes(value={"org.drombler.acp.core.application.Extensions", "org.drombler.acp.core.application.Extension"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ExtensionAnnotationProcessor
extends AbstractApplicationAnnotationProcessor {
    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(Extensions.class).forEach(element -> {
            Extensions extensionsAnnotation = element.getAnnotation(Extensions.class);
            if (extensionsAnnotation != null) {
                for (Extension extensionAnnotation : extensionsAnnotation.value()) {
                    this.registerExtensionAnnotation(extensionAnnotation, (Element)element);
                }
            }
        });
        roundEnv.getElementsAnnotatedWith(Extension.class).forEach(element -> {
            Extension extensionAnnotation = element.getAnnotation(Extension.class);
            if (extensionAnnotation != null) {
                this.registerExtensionAnnotation(extensionAnnotation, (Element)element);
            }
        });
        return false;
    }

    private void init(Extension extensionAnnotation, Element element) {
        TypeMirror extensionJAXBRootClass = this.getExtensionJAXBRootClass(extensionAnnotation);
        ExtensionAnnotationProcessor.addJAXBPackage(this.getPackageName(extensionJAXBRootClass));
        ExtensionAnnotationProcessor.addOriginatingElements(element);
    }

    private String getPackageName(TypeMirror extensionJAXBRootClass) {
        String rootClassName = extensionJAXBRootClass.toString();
        return rootClassName.substring(0, rootClassName.lastIndexOf("."));
    }

    private void registerExtensionAnnotation(Extension extensionAnnotation, Element element) {
        this.init(extensionAnnotation, element);
        try {
            Object extension = this.readExtensionFile(extensionAnnotation.extensionFile());
            ExtensionAnnotationProcessor.addExtensionConfigurations(extension);
        }
        catch (IOException | JAXBException ex) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), element);
        }
    }

    private Object readExtensionFile(String extensionFile) throws JAXBException, IOException {
        JAXBContext jaxbContext = this.createJAXBContext();
        FileObject extensionFileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", extensionFile);
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        try (InputStream is = extensionFileObject.openInputStream();){
            Object object = unmarshaller.unmarshal(is);
            return object;
        }
    }

    private TypeMirror getExtensionJAXBRootClass(Extension extensionAnnotation) {
        return this.getTypeMirror(extensionAnnotation::extensionJAXBRootClass);
    }

    private TypeMirror getTypeMirror(Supplier<Class<?>> supplier) {
        TypeMirror typeMirror = null;
        try {
            supplier.get();
        }
        catch (MirroredTypeException mte) {
            typeMirror = mte.getTypeMirror();
        }
        return typeMirror;
    }
}

