/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.application.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.drombler.acp.core.application.ExtensionPoint;
import org.drombler.acp.core.application.jaxb.ApplicationType;
import org.drombler.acp.core.application.jaxb.ExtensionsType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationTracker.class);
    private BundleTracker<ApplicationType> bundleTracker;
    private final Set<Class<?>> jaxbRootClassesSet = new HashSet<Class>(Arrays.asList(ApplicationType.class));
    private Class[] jaxbRootClasses = new Class[]{ApplicationType.class};
    private final Map<Long, List<ServiceRegistration<?>>> serviceRegistrations = new HashMap();
    private final Set<Bundle> unresolvedExtensions = new LinkedHashSet<Bundle>();

    public void activate(BundleContext context) {
        this.bundleTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)new BundleTrackerCustomizer<ApplicationType>(){

            public ApplicationType addingBundle(Bundle bundle, BundleEvent event) {
                return ApplicationTracker.this.registerExtensions(bundle);
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, ApplicationType application) {
            }

            public void removedBundle(Bundle bundle, BundleEvent event, ApplicationType application) {
                ApplicationTracker.this.unregisterExtensions(bundle);
            }
        });
        this.bundleTracker.open();
    }

    public void deactivate() {
        this.bundleTracker.close();
    }

    private ApplicationType registerExtensions(Bundle bundle) {
        URL actionsURL = bundle.getEntry("META-INF/platform/application.xml");
        if (actionsURL != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])this.jaxbRootClasses);
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                ApplicationType application = (ApplicationType)unmarshaller.unmarshal(actionsURL);
                if (this.loadedExtensionsSuccessfully(application.getExtensions())) {
                    if (this.unresolvedExtensions.contains(bundle)) {
                        this.unresolvedExtensions.remove(bundle);
                    }
                    this.registerExtensions(bundle, application.getExtensions());
                    return application;
                }
                if (!this.unresolvedExtensions.contains(bundle)) {
                    this.unresolvedExtensions.add(bundle);
                }
            }
            catch (JAXBException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private boolean loadedExtensionsSuccessfully(ExtensionsType extensions) {
        boolean successfullyLoaded = true;
        for (Object extension : extensions.getAny()) {
            if (this.jaxbRootClassesSet.contains(extension.getClass())) continue;
            successfullyLoaded = false;
            break;
        }
        return successfullyLoaded;
    }

    private void registerExtensions(Bundle bundle, ExtensionsType extensions) {
        ArrayList<ServiceRegistration> registrations = new ArrayList<ServiceRegistration>(extensions.getAny().size());
        for (Object extension : extensions.getAny()) {
            ServiceRegistration serviceRegistration = bundle.getBundleContext().registerService(extension.getClass().getName(), extension, null);
            registrations.add(serviceRegistration);
        }
        this.serviceRegistrations.put(bundle.getBundleId(), registrations);
    }

    private void unregisterExtensions(Bundle bundle) {
        if (this.serviceRegistrations.containsKey(bundle.getBundleId())) {
            for (ServiceRegistration<?> serviceRegistration : this.serviceRegistrations.remove(bundle.getBundleId())) {
                serviceRegistration.unregister();
            }
        }
        if (this.unresolvedExtensions.contains(bundle)) {
            this.unresolvedExtensions.remove(bundle);
        }
    }

    public void bindExtensionPoint(ExtensionPoint<?> extensionPoint) {
        this.jaxbRootClassesSet.add(extensionPoint.getJAXBRootClass());
        this.jaxbRootClasses = new ArrayList(this.jaxbRootClassesSet).toArray(new Class[this.jaxbRootClassesSet.size()]);
        if (!this.unresolvedExtensions.isEmpty()) {
            ArrayList<Bundle> extensionBundles = new ArrayList<Bundle>(this.unresolvedExtensions);
            for (Bundle extensionBundle : extensionBundles) {
                this.registerExtensions(extensionBundle);
            }
        }
    }

    public void unbindExtensionPoint(ExtensionPoint<?> extensionPoint) {
        this.jaxbRootClassesSet.remove(extensionPoint.getJAXBRootClass());
        this.jaxbRootClasses = new ArrayList(this.jaxbRootClassesSet).toArray(new Class[this.jaxbRootClassesSet.size()]);
    }
}

