/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.application.processing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.drombler.acp.core.application.jaxb.ApplicationType;
import org.drombler.acp.core.application.jaxb.ExtensionsType;

public abstract class AbstractApplicationAnnotationProcessor
extends AbstractProcessor {
    private static final Set<String> JAXB_PACKAGES = new HashSet<String>();
    private static final List<Object> EXTENSION_CONFIGURATIONS = new ArrayList<Object>();
    private static final List<Element> ORIGINATING_ELEMENTS = new ArrayList<Element>();
    private static FileObject APPLICATION_FILE_OBJECT = null;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean claimed = this.handleProcess(annotations, roundEnv);
        if (roundEnv.processingOver()) {
            this.writeApplicationFile();
        }
        return claimed;
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    private void writeApplicationFile() {
        if (APPLICATION_FILE_OBJECT == null) {
            Filer filer = this.processingEnv.getFiler();
            Messager messager = this.processingEnv.getMessager();
            try {
                JAXBContext jaxbContext = this.createJAXBContext();
                ApplicationType application = this.readManualApplicationFile(filer, jaxbContext);
                if (application == null) {
                    application = new ApplicationType();
                }
                if (application.getExtensions() == null) {
                    ExtensionsType extensions = new ExtensionsType();
                    application.setExtensions(extensions);
                }
                application.getExtensions().getAny().addAll(EXTENSION_CONFIGURATIONS);
                this.writeApplicationFile(filer, jaxbContext, application);
            }
            catch (IOException | JAXBException ex) {
                messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            }
        }
    }

    protected JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)String.join((CharSequence)":", JAXB_PACKAGES.toArray(new String[JAXB_PACKAGES.size()])), (ClassLoader)ApplicationType.class.getClassLoader());
    }

    private void writeApplicationFile(Filer filer, JAXBContext jaxbContext, ApplicationType application) throws JAXBException, IOException {
        APPLICATION_FILE_OBJECT = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "META-INF/drombler/application.xml", ORIGINATING_ELEMENTS.toArray(new Element[ORIGINATING_ELEMENTS.size()]));
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        try (Writer writer = APPLICATION_FILE_OBJECT.openWriter();){
            marshaller.marshal((Object)application, writer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ApplicationType readManualApplicationFile(Filer filer, JAXBContext jaxbContext) throws IOException, JAXBException {
        FileObject applicationXmlFileObject = this.getManualApplicationXml(filer);
        if (applicationXmlFileObject == null) return null;
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        try (InputStream is = applicationXmlFileObject.openInputStream();){
            ApplicationType applicationType = (ApplicationType)unmarshaller.unmarshal(is);
            return applicationType;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    private FileObject getManualApplicationXml(Filer filer) {
        try {
            FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/drombler/application.xml");
            return fileObject;
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected static void addJAXBRootClass(Class<?> jaxbRootClass) {
        JAXB_PACKAGES.add(jaxbRootClass.getPackage().getName());
    }

    protected static void addJAXBPackage(String jaxbPackageName) {
        JAXB_PACKAGES.add(jaxbPackageName);
    }

    protected static void addExtensionConfiguration(Object extensionConfiguration) {
        EXTENSION_CONFIGURATIONS.add(extensionConfiguration);
    }

    protected static void addOriginatingElements(Element ... originatingElements) {
        ORIGINATING_ELEMENTS.addAll(Arrays.asList(originatingElements));
    }

    static {
        AbstractApplicationAnnotationProcessor.addJAXBRootClass(ApplicationType.class);
    }
}

