/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.application;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.drombler.acp.core.application.jaxb.ApplicationType;
import org.drombler.acp.core.application.jaxb.ExtensionsType;

public abstract class AbstractApplicationAnnotationProcessor
extends AbstractProcessor {
    private static final String APPLICATION_XML_RELATIVE_NAME = "META-INF/platform/application.xml";
    private static final List<Class<?>> JAXB_ROOT_CLASSES = new ArrayList<Class>(Arrays.asList(ApplicationType.class));
    private static final List<Object> EXTENSION_CONFIGURATIONS = new ArrayList<Object>();
    private static final List<Object> ORIGINATING_ELEMENTS = new ArrayList<Object>();
    private static FileObject APPLICATION_FILE_OBJECT = null;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean claimed = this.handleProcess(annotations, roundEnv);
        if (roundEnv.processingOver()) {
            this.writeApplicationFile();
        }
        return claimed;
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    private void writeApplicationFile() {
        Filer filer = this.processingEnv.getFiler();
        Messager messager = this.processingEnv.getMessager();
        if (APPLICATION_FILE_OBJECT == null) {
            try {
                APPLICATION_FILE_OBJECT = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", APPLICATION_XML_RELATIVE_NAME, ORIGINATING_ELEMENTS.toArray(new Element[ORIGINATING_ELEMENTS.size()]));
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])JAXB_ROOT_CLASSES.toArray(new Class[JAXB_ROOT_CLASSES.size()]));
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                ApplicationType application = new ApplicationType();
                ExtensionsType extensions = new ExtensionsType();
                extensions.getAny().addAll(EXTENSION_CONFIGURATIONS);
                application.setExtensions(extensions);
                try (Writer writer = APPLICATION_FILE_OBJECT.openWriter();){
                    marshaller.marshal((Object)application, writer);
                }
            }
            catch (IOException | JAXBException ex) {
                messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            }
        }
    }

    protected static void addJAXBRootClasses(Class<?> jaxbRootClasses) {
        JAXB_ROOT_CLASSES.add(jaxbRootClasses);
    }

    protected static void addExtensionConfigurations(Object extensionConfigurations) {
        EXTENSION_CONFIGURATIONS.add(extensionConfigurations);
    }

    protected static void addOriginatingElements(Element ... originatingElements) {
        ORIGINATING_ELEMENTS.addAll(Arrays.asList(originatingElements));
    }
}

