/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.drombler.acp.core.action.jaxb.MenuEntryType;
import org.drombler.acp.core.action.jaxb.MenusType;
import org.drombler.acp.core.action.spi.AbstractMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ActionFactory;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.MenuEntryDescriptor;
import org.drombler.acp.core.action.spi.MenuItemFactory;
import org.drombler.acp.core.action.spi.impl.AbstractMenuItemHandler;
import org.drombler.acp.core.action.spi.impl.ActionResolutionManager;
import org.drombler.acp.core.action.spi.impl.MenuItemConfig;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class MenuItemHandler<MenuItem, Menu extends MenuItem, Action>
extends AbstractMenuItemHandler<MenuItem, Menu, MenuItem, MenuEntryDescriptor, MenuItemConfig<Action>> {
    private MenuItemFactory<MenuItem, Action> menuItemFactory;
    private ActionFactory<Action> actionFactory;
    private final ActionRegistry actionRegistry = new ActionRegistry();
    private final ActionResolutionManager<MenuEntryDescriptor> actionResolutionManager = new ActionResolutionManager();
    private ServiceTracker<Action, ServiceReference<Action>> tracker;

    protected void bindMenuEntryDescriptor(ServiceReference<MenuEntryDescriptor> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        MenuEntryDescriptor menuEntryDescriptor = (MenuEntryDescriptor)context.getService(serviceReference);
        this.resolveMenuItem(menuEntryDescriptor, context);
    }

    protected void unbindMenuEntryDescriptor(ServiceReference<MenuEntryDescriptor> serviceReference) {
    }

    protected void bindMenuItemFactory(MenuItemFactory<MenuItem, Action> menuItemFactory) {
        this.menuItemFactory = menuItemFactory;
    }

    protected void unbindMenuItemFactory(MenuItemFactory<MenuItem, Action> menuItemFactory) {
        this.menuItemFactory = null;
    }

    protected void bindActionFactory(ActionFactory<Action> actionFactory) {
        this.actionFactory = actionFactory;
    }

    protected void unbindActionFactory(ActionFactory<Action> actionFactory) {
        this.actionFactory = null;
    }

    protected void activate(ComponentContext context) {
        this.tracker = this.createActionTracker(context);
        this.tracker.open();
        this.resolveUnresolvedItems();
    }

    protected void deactivate(ComponentContext context) {
        this.tracker.close();
    }

    private ServiceTracker<Action, ServiceReference<Action>> createActionTracker(ComponentContext context) {
        return new ServiceTracker(context.getBundleContext(), this.actionFactory.getActionClass(), new ServiceTrackerCustomizer<Action, ServiceReference<Action>>(){

            public ServiceReference<Action> addingService(ServiceReference<Action> reference) {
                String actionId = MenuItemHandler.this.actionRegistry.getActionId(reference);
                if (MenuItemHandler.this.actionResolutionManager.containsUnresolvedEntries(actionId)) {
                    for (UnresolvedEntry unresolvedEntry : MenuItemHandler.this.actionResolutionManager.removeUnresolvedEntries(actionId)) {
                        MenuItemHandler.this.resolveMenuItem((AbstractMenuEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
                    }
                }
                return reference;
            }

            public void modifiedService(ServiceReference<Action> reference, ServiceReference<Action> service) {
            }

            public void removedService(ServiceReference<Action> reference, ServiceReference<Action> service) {
            }
        });
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.menuItemFactory != null && this.actionFactory != null;
    }

    @Override
    protected void resolveMenuItem(MenusType menusType, Bundle bundle, BundleContext context) {
        for (MenuEntryType menuEntry : menusType.getMenuEntry()) {
            MenuEntryDescriptor menuEntryDescriptor = MenuEntryDescriptor.createMenuEntryDescriptor(menuEntry);
            this.resolveMenuItem(menuEntryDescriptor, context);
        }
    }

    @Override
    protected MenuItemConfig<Action> createConfig(MenuEntryDescriptor menuEntryDescriptor, BundleContext context) {
        Action action = this.actionRegistry.getAction(menuEntryDescriptor.getActionId(), this.actionFactory.getActionClass(), context);
        if (action != null) {
            return new MenuItemConfig<Action>(action);
        }
        return null;
    }

    @Override
    protected MenuItem createMenuItem(MenuEntryDescriptor menuEntryDescriptor, MenuItemConfig<Action> config) {
        return this.menuItemFactory.createMenuItem(config.getAction(), config.getIconSize());
    }

    @Override
    protected void registerUnresolvedMenuItem(MenuEntryDescriptor menuEntryDescriptor, BundleContext context) {
        this.actionResolutionManager.addUnresolvedEntry(menuEntryDescriptor.getActionId(), new UnresolvedEntry<MenuEntryDescriptor>(menuEntryDescriptor, context));
    }
}

