/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.drombler.acp.core.action.jaxb.ActionsType;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.drombler.acp.core.application.ApplicationExecutorProvider;
import org.drombler.commons.context.ActiveContextProvider;
import org.drombler.commons.context.ApplicationContextProvider;
import org.drombler.commons.context.ContextInjector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionHandler<A, D> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActionHandler.class);
    private ActiveContextProvider activeContextProvider;
    private ApplicationContextProvider applicationContextProvider;
    private Executor applicationExecutor;
    private ContextInjector contextInjector;
    private final ActionRegistry actionRegistry = new ActionRegistry();
    private final List<UnresolvedEntry<A>> unresolvedActions = new ArrayList<UnresolvedEntry<A>>();
    private final List<UnresolvedEntry<D>> unresolvedActionDescriptors = new ArrayList<UnresolvedEntry<D>>();

    protected void bindActiveContextProvider(ActiveContextProvider activeContextProvider) {
        this.activeContextProvider = activeContextProvider;
    }

    protected void unbindActiveContextProvider(ActiveContextProvider activeContextProvider) {
        this.activeContextProvider = null;
    }

    protected void bindApplicationContextProvider(ApplicationContextProvider applicationContextProvider) {
        this.applicationContextProvider = applicationContextProvider;
    }

    protected void unbindApplicationContextProvider(ApplicationContextProvider applicationContextProvider) {
        this.applicationContextProvider = null;
    }

    protected void bindActionsType(ServiceReference<ActionsType> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        ActionsType actionsType = (ActionsType)context.getService(serviceReference);
        this.registerActions(actionsType, context);
    }

    protected void unbindActionsType(ActionsType actionsType) {
    }

    protected void bindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = applicationExecutorProvider.getApplicationExecutor();
    }

    protected void unbindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = null;
    }

    protected void activate(ComponentContext context) {
        this.contextInjector = new ContextInjector(this.activeContextProvider, this.applicationContextProvider);
        this.resolveUnresolvedItems();
    }

    protected void deactivate(ComponentContext context) {
    }

    protected boolean isInitialized() {
        return this.activeContextProvider != null && this.applicationContextProvider != null && this.getContextInjector() != null && this.applicationExecutor != null;
    }

    protected abstract void registerActions(ActionsType var1, BundleContext var2);

    protected void resolveUnresolvedItems() {
        this.resolveUnresolvedActions();
        this.resolveUnresolvedActionDescriptors();
    }

    private void resolveUnresolvedActions() {
        this.unresolvedActions.forEach(entry -> this.registerActionType(entry.getEntry(), entry.getContext()));
    }

    private void resolveUnresolvedActionDescriptors() {
        this.unresolvedActionDescriptors.forEach(entry -> this.registerActionDescriptor(entry.getEntry(), entry.getContext()));
    }

    protected void registerActionType(A actionType, BundleContext context) {
        if (this.isInitialized()) {
            this.applicationExecutor.execute(() -> {
                try {
                    D actionDescriptor = this.createActionDescriptor(actionType, context);
                    this.registerActionDescriptor(actionDescriptor, context);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            });
        } else {
            this.unresolvedActions.add(new UnresolvedEntry<A>(actionType, context));
        }
    }

    protected abstract D createActionDescriptor(A var1, BundleContext var2) throws IllegalAccessException, ClassNotFoundException, InstantiationException;

    protected abstract void registerActionDescriptor(D var1, BundleContext var2);

    protected void registerUnresolvedActionDescriptor(D actionDescriptor, BundleContext context) {
        this.unresolvedActionDescriptors.add(new UnresolvedEntry<D>(actionDescriptor, context));
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    protected ContextInjector getContextInjector() {
        return this.contextInjector;
    }
}

