/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.action.jaxb.ToolBarType;
import org.drombler.acp.core.action.spi.ToggleActionDescriptor;
import org.drombler.acp.core.action.spi.ToggleMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ToolBarContainer;
import org.drombler.acp.core.action.spi.impl.ShowToolBarAction;
import org.drombler.acp.core.commons.util.OSGiResourceBundleUtils;
import org.osgi.framework.Bundle;
import org.softsmithy.lib.util.Positionable;

public class ToolBarDescriptor
implements Positionable {
    private String id;
    private String displayName;
    private int position;
    private boolean visible;
    private ToggleActionDescriptor showToolBarActionDescriptor;
    private ToggleMenuEntryDescriptor showToolBarCheckMenuEntryDescriptor;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static <T, B> ToolBarDescriptor createToolBarDescriptor(ToolBarType toolBarType, Bundle bundle, ToolBarContainer<T, B> toolBarContainer) {
        ToolBarDescriptor toolBarDescriptor = new ToolBarDescriptor();
        toolBarDescriptor.setId(StringUtils.stripToNull((String)toolBarType.getId()));
        toolBarDescriptor.setDisplayName(OSGiResourceBundleUtils.getPackageResourceStringPrefixed((String)toolBarType.getPackage(), (String)toolBarType.getDisplayName(), (Bundle)bundle));
        toolBarDescriptor.setPosition(toolBarType.getPosition());
        toolBarDescriptor.setVisible(toolBarType.isVisible());
        ToggleActionDescriptor actionDescriptor = ToolBarDescriptor.createShowToolBarActionDescriptor(toolBarDescriptor, toolBarContainer);
        toolBarDescriptor.setShowToolBarActionDescriptor(actionDescriptor);
        toolBarDescriptor.setShowToolBarCheckMenuEntryDescriptor(new ToggleMenuEntryDescriptor(actionDescriptor.getId(), "View/Toolbars", toolBarType.getPosition()));
        return toolBarDescriptor;
    }

    private static <T, B> ToggleActionDescriptor createShowToolBarActionDescriptor(ToolBarDescriptor toolBarDescriptor, ToolBarContainer<T, B> toolBarContainer) {
        ToggleActionDescriptor actionDescriptor = new ToggleActionDescriptor();
        actionDescriptor.setId(ShowToolBarAction.class.getName() + "#" + toolBarDescriptor.getId());
        actionDescriptor.setDisplayName(toolBarDescriptor.getDisplayName());
        actionDescriptor.setListener(new ShowToolBarAction<T, B>(toolBarDescriptor.getId(), toolBarContainer));
        return actionDescriptor;
    }

    public ToggleActionDescriptor getShowToolBarActionDescriptor() {
        return this.showToolBarActionDescriptor;
    }

    public void setShowToolBarActionDescriptor(ToggleActionDescriptor showToolBarActionDescriptor) {
        this.showToolBarActionDescriptor = showToolBarActionDescriptor;
    }

    public ToggleMenuEntryDescriptor getShowToolBarCheckMenuEntryDescriptor() {
        return this.showToolBarCheckMenuEntryDescriptor;
    }

    public void setShowToolBarCheckMenuEntryDescriptor(ToggleMenuEntryDescriptor showToolBarCheckMenuEntryDescriptor) {
        this.showToolBarCheckMenuEntryDescriptor = showToolBarCheckMenuEntryDescriptor;
    }
}

