/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ActionRegistry.class);

    public <T> T getAction(String actionId, Class<T> actionClass, BundleContext context) {
        try {
            Collection serviceReferences = context.getServiceReferences(actionClass, "(" + ActionDescriptor.ID_KEY + "=" + actionId + ")");
            if (!serviceReferences.isEmpty()) {
                return (T)context.getService((ServiceReference)serviceReferences.iterator().next());
            }
        }
        catch (InvalidSyntaxException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public <T> void registerAction(String actionId, Class<T> actionClass, T action, BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put(ActionDescriptor.ID_KEY, actionId);
        context.registerService(actionClass, action, properties);
    }

    public String getActionId(ServiceReference<?> reference) {
        return reference.getProperty(ActionDescriptor.ID_KEY).toString();
    }
}

