/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.concurrent.Executor;
import org.drombler.acp.core.action.jaxb.ToolBarType;
import org.drombler.acp.core.action.jaxb.ToolBarsType;
import org.drombler.acp.core.action.spi.ToggleActionDescriptor;
import org.drombler.acp.core.action.spi.ToggleMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ToolBarDescriptor;
import org.drombler.acp.core.action.spi.ToolBarFactory;
import org.drombler.acp.core.action.spi.impl.AbstractToolBarHandler;
import org.drombler.acp.core.action.spi.impl.ToolBarResolutionManager;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.drombler.acp.core.application.ApplicationExecutorProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.softsmithy.lib.util.PositionableAdapter;

public class ToolBarsHandler<T, B>
extends AbstractToolBarHandler<T, B> {
    private final ToolBarResolutionManager toolBarResolutionManager = new ToolBarResolutionManager();
    private ToolBarFactory<T> toolBarFactory;
    private Executor applicationExecutor;

    protected void bindToolBarFactory(ToolBarFactory<T> toolBarFactory) {
        this.toolBarFactory = toolBarFactory;
    }

    protected void unbindToolBarFactory(ToolBarFactory<T> toolBarFactory) {
        this.toolBarFactory = null;
    }

    protected void bindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = applicationExecutorProvider.getApplicationExecutor();
    }

    protected void unbindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = null;
    }

    @Override
    protected void activate(ComponentContext context) {
        super.activate(context);
    }

    @Override
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    @Override
    protected void resolveToolBarsType(ToolBarsType toolBarsType, Bundle bundle, BundleContext context) {
        for (ToolBarType toolBarType : toolBarsType.getToolBar()) {
            this.resolveToolBar(toolBarType, bundle, context);
        }
    }

    private void resolveToolBar(ToolBarType toolBarType, Bundle bundle, BundleContext context) {
        if (this.isInitialized()) {
            ToolBarDescriptor toolBarDescriptor = ToolBarDescriptor.createToolBarDescriptor(toolBarType, bundle, this.getToolBarContainer());
            this.resolveToolBar(toolBarDescriptor, context);
        } else {
            this.toolBarResolutionManager.addUnresolvedToolBarType(new UnresolvedEntry<ToolBarType>(toolBarType, context));
        }
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.toolBarFactory != null && this.applicationExecutor != null;
    }

    protected void resolveToolBar(final ToolBarDescriptor toolBarDescriptor, final BundleContext context) {
        if (this.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object toolBar = ToolBarsHandler.this.toolBarFactory.createToolBar(toolBarDescriptor);
                    ToolBarsHandler.this.getToolBarContainer().addToolBar(toolBarDescriptor.getId(), new PositionableAdapter(toolBar, toolBarDescriptor.getPosition()));
                    ToolBarsHandler.this.getToolBarContainer().setToolBarVisible(toolBarDescriptor.getId(), toolBarDescriptor.isVisible());
                    context.registerService(ToggleActionDescriptor.class, (Object)toolBarDescriptor.getShowToolBarActionDescriptor(), null);
                    context.registerService(ToggleMenuEntryDescriptor.class, (Object)toolBarDescriptor.getShowToolBarCheckMenuEntryDescriptor(), null);
                }
            };
            this.applicationExecutor.execute(runnable);
        } else {
            this.registerUnresolvedToolBar(toolBarDescriptor, context);
        }
    }

    private void registerUnresolvedToolBar(ToolBarDescriptor toolBarDescriptor, BundleContext context) {
        this.toolBarResolutionManager.addUnresolvedToolBar(new UnresolvedEntry<ToolBarDescriptor>(toolBarDescriptor, context));
    }

    @Override
    protected void resolveUnresolvedItems() {
        if (this.isInitialized()) {
            for (UnresolvedEntry<ToolBarType> unresolvedEntry : this.toolBarResolutionManager.removeUnresolvedToolBarTypes()) {
                this.resolveToolBar(unresolvedEntry.getEntry(), unresolvedEntry.getContext().getBundle(), unresolvedEntry.getContext());
            }
            for (UnresolvedEntry<Object> unresolvedEntry : this.toolBarResolutionManager.removeUnresolvedToolBars()) {
                this.resolveToolBar((ToolBarDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
            }
        }
    }
}

