/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.drombler.acp.core.action.jaxb.MenusType;
import org.drombler.acp.core.action.jaxb.ToggleMenuEntryType;
import org.drombler.acp.core.action.spi.AbstractMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.ToggleActionFactory;
import org.drombler.acp.core.action.spi.ToggleMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ToggleMenuItemFactory;
import org.drombler.acp.core.action.spi.impl.AbstractMenuItemHandler;
import org.drombler.acp.core.action.spi.impl.ActionResolutionManager;
import org.drombler.acp.core.action.spi.impl.MenuItemConfig;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ToggleMenuItemHandler<MenuItem, Menu extends MenuItem, ToggleMenuItem extends MenuItem, ToggleAction>
extends AbstractMenuItemHandler<MenuItem, Menu, ToggleMenuItem, ToggleMenuEntryDescriptor, MenuItemConfig<ToggleAction>> {
    private ToggleMenuItemFactory<ToggleMenuItem, ToggleAction> toggleMenuItemFactory;
    private ToggleActionFactory<ToggleAction> toggleActionFactory;
    private final ActionRegistry actionRegistry = new ActionRegistry();
    private final ActionResolutionManager<ToggleMenuEntryDescriptor> actionResolutionManager = new ActionResolutionManager();
    private ServiceTracker<ToggleAction, ServiceReference<ToggleAction>> tracker;

    protected void bindToggleMenuEntryDescriptor(ServiceReference<ToggleMenuEntryDescriptor> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        ToggleMenuEntryDescriptor menuEntryDescriptor = (ToggleMenuEntryDescriptor)context.getService(serviceReference);
        this.resolveMenuItem(menuEntryDescriptor, context);
    }

    protected void unbindToggleMenuEntryDescriptor(ServiceReference<ToggleMenuEntryDescriptor> serviceReference) {
    }

    protected void bindToggleMenuItemFactory(ToggleMenuItemFactory<ToggleMenuItem, ToggleAction> toggleMenuItemFactory) {
        this.toggleMenuItemFactory = toggleMenuItemFactory;
    }

    protected void unbindToggleMenuItemFactory(ToggleMenuItemFactory<ToggleMenuItem, ToggleAction> toggleMenuItemFactory) {
        this.toggleMenuItemFactory = null;
    }

    protected void bindToggleActionFactory(ToggleActionFactory<ToggleAction> toggleActionFactory) {
        this.toggleActionFactory = toggleActionFactory;
    }

    protected void unbindToggleActionFactory(ToggleActionFactory<ToggleAction> toggleActionFactory) {
        this.toggleActionFactory = null;
    }

    protected void activate(ComponentContext context) {
        this.tracker = this.createActionTracker(context);
        this.tracker.open();
        this.resolveUnresolvedItems();
    }

    protected void deactivate(ComponentContext context) {
        this.tracker.close();
    }

    private ServiceTracker<ToggleAction, ServiceReference<ToggleAction>> createActionTracker(ComponentContext context) {
        return new ServiceTracker(context.getBundleContext(), this.toggleActionFactory.getToggleActionClass(), new ServiceTrackerCustomizer<ToggleAction, ServiceReference<ToggleAction>>(){

            public ServiceReference<ToggleAction> addingService(ServiceReference<ToggleAction> reference) {
                String actionId = ToggleMenuItemHandler.this.actionRegistry.getActionId(reference);
                if (ToggleMenuItemHandler.this.actionResolutionManager.containsUnresolvedEntries(actionId)) {
                    for (UnresolvedEntry unresolvedEntry : ToggleMenuItemHandler.this.actionResolutionManager.removeUnresolvedEntries(actionId)) {
                        ToggleMenuItemHandler.this.resolveMenuItem((AbstractMenuEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
                    }
                }
                return reference;
            }

            public void modifiedService(ServiceReference<ToggleAction> reference, ServiceReference<ToggleAction> service) {
            }

            public void removedService(ServiceReference<ToggleAction> reference, ServiceReference<ToggleAction> service) {
            }
        });
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.toggleMenuItemFactory != null && this.toggleActionFactory != null;
    }

    @Override
    protected void resolveMenuItem(MenusType menusType, Bundle bundle, BundleContext context) {
        for (ToggleMenuEntryType menuEntry : menusType.getToggleMenuEntry()) {
            ToggleMenuEntryDescriptor menuEntryDescriptor = ToggleMenuEntryDescriptor.createRadioMenuEntryDescriptor(menuEntry);
            this.resolveMenuItem(menuEntryDescriptor, context);
        }
    }

    @Override
    protected MenuItemConfig<ToggleAction> createConfig(ToggleMenuEntryDescriptor menuEntryDescriptor, BundleContext context) {
        ToggleAction action = this.actionRegistry.getAction(menuEntryDescriptor.getActionId(), this.toggleActionFactory.getToggleActionClass(), context);
        if (action != null) {
            return new MenuItemConfig<ToggleAction>(action);
        }
        return null;
    }

    @Override
    protected ToggleMenuItem createMenuItem(ToggleMenuEntryDescriptor menuEntryDescriptor, MenuItemConfig<ToggleAction> config) {
        return this.toggleMenuItemFactory.createToggleMenuItem(menuEntryDescriptor, config.getAction(), config.getIconSize());
    }

    @Override
    protected void registerUnresolvedMenuItem(ToggleMenuEntryDescriptor menuEntryDescriptor, BundleContext context) {
        this.actionResolutionManager.addUnresolvedEntry(menuEntryDescriptor.getActionId(), new UnresolvedEntry<ToggleMenuEntryDescriptor>(menuEntryDescriptor, context));
    }
}

