/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.drombler.acp.core.action.jaxb.MenuType;
import org.drombler.acp.core.action.jaxb.MenusType;
import org.drombler.acp.core.action.spi.MenuDescriptor;
import org.drombler.acp.core.action.spi.MenuFactory;
import org.drombler.acp.core.action.spi.MenuItemContainer;
import org.drombler.acp.core.action.spi.PositionableMenuItemAdapter;
import org.drombler.acp.core.action.spi.impl.AbstractMenuItemHandler;
import org.drombler.acp.core.action.spi.impl.MenuConfig;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class MenuHandler<MenuItem, Menu extends MenuItem>
extends AbstractMenuItemHandler<MenuItem, Menu, Menu, MenuDescriptor, MenuConfig> {
    private MenuFactory<Menu> menuFactory;

    protected void bindMenuDescriptor(MenuDescriptor menuDescriptor) {
        this.resolveMenu(menuDescriptor);
    }

    protected void unbindMenuDescriptor(MenuDescriptor menuDescriptor) {
    }

    protected void bindMenuFactory(MenuFactory<Menu> menuFactory) {
        this.menuFactory = menuFactory;
    }

    protected void unbindMenuFactory(MenuFactory<Menu> menuFactory) {
        this.menuFactory = null;
    }

    protected void activate(ComponentContext context) {
        this.resolveUnresolvedItems();
    }

    protected void deactivate(ComponentContext context) {
    }

    private void resolveMenu(MenuDescriptor entry) {
        this.resolveMenuItem(entry, null);
    }

    @Override
    protected void resolveMenuItem(MenusType menusType, Bundle bundle, BundleContext context) {
        for (MenuType menu : menusType.getMenu()) {
            MenuDescriptor menuDescriptor = MenuDescriptor.createMenuDescriptor(menu, bundle);
            this.resolveMenu(menuDescriptor);
        }
    }

    @Override
    protected void addToContainer(MenuItemContainer<MenuItem, Menu> parentContainer, Menu menuItem, MenuDescriptor menuDescriptor) {
        parentContainer.addMenu(menuDescriptor.getId(), PositionableMenuItemAdapter.wrapMenuItem(menuItem, menuDescriptor.getPosition()));
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.menuFactory != null;
    }

    @Override
    protected MenuConfig createConfig(MenuDescriptor menuEntryDescriptor, BundleContext context) {
        return MenuConfig.getInstance();
    }

    @Override
    protected Menu createMenuItem(MenuDescriptor menuEntryDescriptor, MenuConfig config) {
        return this.menuFactory.createMenu(menuEntryDescriptor);
    }

    @Override
    protected void registerUnresolvedMenuItem(MenuDescriptor menuEntryDescriptor, BundleContext context) {
    }
}

