/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.concurrent.Executor;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.ToolBarContainerListenerAdapter;
import org.drombler.acp.core.action.spi.ToolBarContainerToolBarEvent;
import org.drombler.acp.core.action.spi.ToolBarEntryDescriptor;
import org.drombler.acp.core.action.spi.impl.AbstractToolBarHandler;
import org.drombler.acp.core.action.spi.impl.ActionResolutionManager;
import org.drombler.acp.core.action.spi.impl.ToolBarEntryResolutionManager;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.drombler.acp.core.application.ApplicationExecutorProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.softsmithy.lib.util.PositionableAdapter;

public abstract class AbstractToolBarButtonHandler<ToolBar, ToolBarButton, Action, D extends ToolBarEntryDescriptor>
extends AbstractToolBarHandler<ToolBar, ToolBarButton> {
    private static final int ICON_SIZE = 24;
    private final ToolBarEntryResolutionManager<D> toolBarEntryResolutionManager = new ToolBarEntryResolutionManager();
    private final ActionRegistry actionRegistry = new ActionRegistry();
    private final ActionResolutionManager<D> actionResolutionManager = new ActionResolutionManager();
    private Executor applicationExecutor;
    private ServiceTracker<Action, ServiceReference<Action>> tracker;

    protected void bindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = applicationExecutorProvider.getApplicationExecutor();
    }

    protected void unbindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = null;
    }

    @Override
    protected void activate(ComponentContext context) {
        this.tracker = this.createActionTracker(context);
        this.tracker.open();
        this.getToolBarContainer().addToolBarContainerListener(new ToolBarContainerListenerAdapter<ToolBar, ToolBarButton>(){

            @Override
            public void toolBarAdded(ToolBarContainerToolBarEvent<ToolBar, ToolBarButton> event) {
                AbstractToolBarButtonHandler.this.resolveUnresolvedToolBarEntries(event.getToolBarId());
            }
        });
        super.activate(context);
    }

    @Override
    protected void deactivate(ComponentContext context) {
        this.tracker.close();
        super.deactivate(context);
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.applicationExecutor != null;
    }

    private ServiceTracker<Action, ServiceReference<Action>> createActionTracker(ComponentContext context) {
        return new ServiceTracker(context.getBundleContext(), this.getActionClass(), new ServiceTrackerCustomizer<Action, ServiceReference<Action>>(){

            public ServiceReference<Action> addingService(ServiceReference<Action> reference) {
                String actionId = AbstractToolBarButtonHandler.this.actionRegistry.getActionId(reference);
                if (AbstractToolBarButtonHandler.this.actionResolutionManager.containsUnresolvedEntries(actionId)) {
                    for (UnresolvedEntry unresolvedEntry : AbstractToolBarButtonHandler.this.actionResolutionManager.removeUnresolvedEntries(actionId)) {
                        AbstractToolBarButtonHandler.this.resolveToolBarEntry((ToolBarEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
                    }
                }
                return reference;
            }

            public void modifiedService(ServiceReference<Action> reference, ServiceReference<Action> service) {
            }

            public void removedService(ServiceReference<Action> reference, ServiceReference<Action> service) {
            }
        });
    }

    protected void resolveToolBarEntry(D toolBarEntryDescriptor, BundleContext context) {
        if (this.isInitialized() && this.getToolBarContainer().containsToolBar(((ToolBarEntryDescriptor)toolBarEntryDescriptor).getToolBarId())) {
            Action action = this.actionRegistry.getAction(((ToolBarEntryDescriptor)toolBarEntryDescriptor).getActionId(), this.getActionClass(), context);
            if (action != null) {
                Runnable runnable = new Runnable((ToolBarEntryDescriptor)toolBarEntryDescriptor, action){
                    final /* synthetic */ ToolBarEntryDescriptor val$toolBarEntryDescriptor;
                    final /* synthetic */ Object val$action;
                    {
                        this.val$toolBarEntryDescriptor = toolBarEntryDescriptor;
                        this.val$action = object;
                    }

                    @Override
                    public void run() {
                        Object button = AbstractToolBarButtonHandler.this.createToolBarButton(this.val$toolBarEntryDescriptor, this.val$action, 24);
                        AbstractToolBarButtonHandler.this.getToolBarContainer().addToolBarButton(this.val$toolBarEntryDescriptor.getToolBarId(), new PositionableAdapter(button, this.val$toolBarEntryDescriptor.getPosition()));
                    }
                };
                this.applicationExecutor.execute(runnable);
            } else {
                this.actionResolutionManager.addUnresolvedEntry(((ToolBarEntryDescriptor)toolBarEntryDescriptor).getActionId(), new UnresolvedEntry<D>(toolBarEntryDescriptor, context));
            }
        } else {
            this.registerUnresolvedToolBarEntry(toolBarEntryDescriptor, context);
        }
    }

    private void registerUnresolvedToolBarEntry(D toolBarEntryDescriptor, BundleContext context) {
        this.toolBarEntryResolutionManager.addUnresolvedToolBarEntry(new UnresolvedEntry<D>(toolBarEntryDescriptor, context));
    }

    private void resolveUnresolvedToolBarEntries(String toolBarId) {
        if (this.toolBarEntryResolutionManager.containsUnresolvedToolBarEntries(toolBarId)) {
            for (UnresolvedEntry<D> unresolvedEntry : this.toolBarEntryResolutionManager.removeUnresolvedToolBarEntries(toolBarId)) {
                this.resolveToolBarEntry((ToolBarEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
            }
        }
    }

    @Override
    protected void resolveUnresolvedItems() {
        for (UnresolvedEntry<D> unresolvedEntry : this.toolBarEntryResolutionManager.removeUnresolvedToolBarEntries()) {
            this.resolveToolBarEntry((ToolBarEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
        }
    }

    protected abstract Class<Action> getActionClass();

    protected abstract ToolBarButton createToolBarButton(D var1, Action var2, int var3);
}

