/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.List;
import java.util.concurrent.Executor;
import org.drombler.acp.core.action.jaxb.MenusType;
import org.drombler.acp.core.action.spi.AbstractMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.MenuBarMenuContainerProvider;
import org.drombler.acp.core.action.spi.MenuItemContainer;
import org.drombler.acp.core.action.spi.MenuItemContainerListenerAdapter;
import org.drombler.acp.core.action.spi.MenuItemContainerMenuEvent;
import org.drombler.acp.core.action.spi.MenuItemRootContainer;
import org.drombler.acp.core.action.spi.PositionableMenuItemAdapter;
import org.drombler.acp.core.action.spi.impl.MenuItemResolutionManager;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.drombler.acp.core.application.ApplicationExecutorProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractMenuItemHandler<MenuItem, Menu extends MenuItem, M extends MenuItem, D extends AbstractMenuEntryDescriptor, Config> {
    private static final String ROOT_PATH_ID = "";
    private Executor applicationExecutor;
    private final MenuItemResolutionManager<D> menuItemResolutionManager = new MenuItemResolutionManager();
    private MenuItemRootContainer<MenuItem, Menu> rootContainer;

    protected void bindMenusType(ServiceReference<MenusType> serviceReference) {
        Bundle bundle = serviceReference.getBundle();
        BundleContext context = bundle.getBundleContext();
        MenusType menusType = (MenusType)context.getService(serviceReference);
        this.resolveMenuItem(menusType, bundle, context);
    }

    protected void unbindMenusType(MenusType menusType) {
    }

    protected void bindMenuBarMenuContainerProvider(MenuBarMenuContainerProvider<MenuItem, Menu> menuBarMenuContainerProvider) {
        this.rootContainer = menuBarMenuContainerProvider.getMenuBarMenuContainer();
        this.rootContainer.addMenuContainerListener(new MenuItemContainerListenerAdapter<MenuItem, Menu>(){

            @Override
            public void menuAdded(MenuItemContainerMenuEvent<MenuItem, Menu> event) {
                MenuItemResolutionManager menuItemResolutionManager = AbstractMenuItemHandler.this.getMenuItemResolutionManager(event.getPath());
                AbstractMenuItemHandler.this.resolveUnresolvedItems(menuItemResolutionManager, event.getMenuId());
            }
        });
        this.resolveUnresolvedItems();
    }

    protected void unbindMenuBarMenuContainerProvider(MenuBarMenuContainerProvider<MenuItem, Menu> menuBarMenuContainerProvider) {
        this.rootContainer = null;
    }

    protected void bindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = applicationExecutorProvider.getApplicationExecutor();
    }

    protected void unbindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = null;
    }

    protected boolean isInitialized() {
        return this.rootContainer != null && this.applicationExecutor != null;
    }

    protected abstract void resolveMenuItem(MenusType var1, Bundle var2, BundleContext var3);

    private MenuItemContainer<MenuItem, Menu> getParent(List<String> path) {
        MenuItemContainer<MenuItem, Menu> parentContainer = this.rootContainer;
        for (String pathId : path) {
            if (parentContainer == null) break;
            parentContainer = parentContainer.getMenuContainer(pathId);
        }
        return parentContainer;
    }

    private MenuItemResolutionManager<D> getMenuItemResolutionManager(List<String> path) {
        MenuItemResolutionManager<D> manager = this.menuItemResolutionManager;
        for (String pathId : path) {
            manager = manager.getMenuResolutionManager(pathId);
        }
        return manager;
    }

    protected void resolveMenuItem(D menuEntryDescriptor, BundleContext context) {
        if (this.isInitialized()) {
            MenuItemContainer<MenuItem, Menu> parentContainer = this.getParent(((AbstractMenuEntryDescriptor)menuEntryDescriptor).getPath());
            if (parentContainer != null) {
                Config config = this.createConfig(menuEntryDescriptor, context);
                if (config != null) {
                    this.resolveMenuItem(config, menuEntryDescriptor, parentContainer);
                } else {
                    this.registerUnresolvedMenuItem(menuEntryDescriptor, context);
                }
            } else {
                this.registerUnresolvedMenuEntry(menuEntryDescriptor, context);
            }
        } else {
            this.registerUnresolvedMenuEntry(menuEntryDescriptor, context);
        }
    }

    protected void resolveMenuItem(Config config, D menuEntryDescriptor, MenuItemContainer<MenuItem, Menu> parentContainer) {
        Runnable runnable = new Runnable((AbstractMenuEntryDescriptor)menuEntryDescriptor, config, parentContainer){
            final /* synthetic */ AbstractMenuEntryDescriptor val$menuEntryDescriptor;
            final /* synthetic */ Object val$config;
            final /* synthetic */ MenuItemContainer val$parentContainer;
            {
                this.val$menuEntryDescriptor = abstractMenuEntryDescriptor;
                this.val$config = object;
                this.val$parentContainer = menuItemContainer;
            }

            @Override
            public void run() {
                Object menuItem = AbstractMenuItemHandler.this.createMenuItem(this.val$menuEntryDescriptor, this.val$config);
                AbstractMenuItemHandler.this.addToContainer(this.val$parentContainer, menuItem, this.val$menuEntryDescriptor);
            }
        };
        this.applicationExecutor.execute(runnable);
    }

    protected abstract Config createConfig(D var1, BundleContext var2);

    protected abstract M createMenuItem(D var1, Config var2);

    protected abstract void registerUnresolvedMenuItem(D var1, BundleContext var2);

    protected void addToContainer(MenuItemContainer<MenuItem, Menu> parentContainer, M menuItem, D menuEntryDescriptor) {
        parentContainer.addMenuItem(PositionableMenuItemAdapter.wrapMenuItem(menuItem, ((AbstractMenuEntryDescriptor)menuEntryDescriptor).getPosition()));
    }

    protected void resolveUnresolvedItems() {
        this.resolveUnresolvedItems(this.menuItemResolutionManager, ROOT_PATH_ID);
    }

    private void resolveUnresolvedItems(MenuItemResolutionManager<D> menuItemResolutionManager, String pathId) {
        if (menuItemResolutionManager.containsUnresolvedMenuEntries(pathId)) {
            for (UnresolvedEntry<D> unresolvedEntry : menuItemResolutionManager.removeUnresolvedMenuEntries(pathId)) {
                this.resolveMenuItem((AbstractMenuEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext());
            }
        }
    }

    private void registerUnresolvedMenuEntry(D menuEntryDescriptor, BundleContext context) {
        MenuItemResolutionManager<D> resolutionManager = this.menuItemResolutionManager;
        String firstUnresolvedPathId = ROOT_PATH_ID;
        if (this.isInitialized()) {
            MenuItemContainer<MenuItem, Menu> parentContainer = this.rootContainer;
            for (String pathId : ((AbstractMenuEntryDescriptor)menuEntryDescriptor).getPath()) {
                if ((parentContainer = parentContainer.getMenuContainer(pathId)) != null) {
                    resolutionManager = resolutionManager.getMenuResolutionManager(pathId);
                    continue;
                }
                firstUnresolvedPathId = pathId;
                break;
            }
        }
        this.registerUnresolvedMenuEntry(resolutionManager, firstUnresolvedPathId, menuEntryDescriptor, context);
    }

    private void registerUnresolvedMenuEntry(MenuItemResolutionManager<D> resolutionManager, String firstUnresolvedPathId, D menuEntryDescriptor, BundleContext context) {
        resolutionManager.addUnresolvedMenuEntry(firstUnresolvedPathId, new UnresolvedEntry<D>(menuEntryDescriptor, context));
    }
}

