/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drombler.acp.core.action.jaxb.ActionsType;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.impl.ActionHandler;
import org.drombler.acp.core.action.spi.impl.UnresolvedEntry;
import org.drombler.acp.core.application.ApplicationExecutorProvider;
import org.drombler.acp.core.commons.util.context.ActiveContextProvider;
import org.drombler.acp.core.commons.util.context.ApplicationContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractActionHandler<A, D> {
    private ActiveContextProvider activeContextProvider;
    private ApplicationContextProvider applicationContextProvider;
    private Executor applicationExecutor;
    private final ActionRegistry actionRegistry = new ActionRegistry();
    private final List<UnresolvedEntry<A>> unresolvedActions = new ArrayList<UnresolvedEntry<A>>();
    private final List<UnresolvedEntry<D>> unresolvedActionDescriptors = new ArrayList<UnresolvedEntry<D>>();

    protected void bindActiveContextProvider(ActiveContextProvider activeContextProvider) {
        this.activeContextProvider = activeContextProvider;
    }

    protected void unbindActiveContextProvider(ActiveContextProvider activeContextProvider) {
        this.activeContextProvider = null;
    }

    protected void bindApplicationContextProvider(ApplicationContextProvider applicationContextProvider) {
        this.applicationContextProvider = applicationContextProvider;
    }

    protected void unbindApplicationContextProvider(ApplicationContextProvider applicationContextProvider) {
        this.applicationContextProvider = null;
    }

    protected void bindActionsType(ServiceReference<ActionsType> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        ActionsType actionsType = (ActionsType)context.getService(serviceReference);
        this.registerActions(actionsType, context);
    }

    protected void unbindActionsType(ActionsType actionsType) {
    }

    protected void bindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = applicationExecutorProvider.getApplicationExecutor();
    }

    protected void unbindApplicationExecutorProvider(ApplicationExecutorProvider applicationExecutorProvider) {
        this.applicationExecutor = null;
    }

    protected boolean isInitialized() {
        return this.getActiveContextProvider() != null && this.getApplicationContextProvider() != null && this.applicationExecutor != null;
    }

    protected abstract void registerActions(ActionsType var1, BundleContext var2);

    protected void resolveUnresolvedItems() {
        this.resolveUnresolvedActions();
        this.resolveUnresolvedActionDescriptors();
    }

    private void resolveUnresolvedActions() {
        for (UnresolvedEntry<A> entry : this.unresolvedActions) {
            this.registerActionType(entry.getEntry(), entry.getContext());
        }
    }

    private void resolveUnresolvedActionDescriptors() {
        for (UnresolvedEntry<D> entry : this.unresolvedActionDescriptors) {
            this.registerActionDescriptor(entry.getEntry(), entry.getContext());
        }
    }

    protected void registerActionType(final A actionType, final BundleContext context) {
        if (this.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Object actionDescriptor = AbstractActionHandler.this.createActionDescriptor(actionType, context);
                        AbstractActionHandler.this.registerActionDescriptor(actionDescriptor, context);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                        Logger.getLogger(ActionHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            this.applicationExecutor.execute(runnable);
        } else {
            this.unresolvedActions.add(new UnresolvedEntry<A>(actionType, context));
        }
    }

    protected abstract D createActionDescriptor(A var1, BundleContext var2) throws IllegalAccessException, ClassNotFoundException, InstantiationException;

    protected abstract void registerActionDescriptor(D var1, BundleContext var2);

    protected void registerUnresolvedActionDescriptor(D actionDescriptor, BundleContext context) {
        this.unresolvedActionDescriptors.add(new UnresolvedEntry<D>(actionDescriptor, context));
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    protected ActiveContextProvider getActiveContextProvider() {
        return this.activeContextProvider;
    }

    protected ApplicationContextProvider getApplicationContextProvider() {
        return this.applicationContextProvider;
    }
}

