/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.concurrent.Executor;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.drombler.acp.core.action.jaxb.ToolBarType;
import org.drombler.acp.core.action.jaxb.ToolBarsType;
import org.drombler.acp.core.action.spi.ToggleActionDescriptor;
import org.drombler.acp.core.action.spi.ToggleMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ToolBarDescriptor;
import org.drombler.acp.core.action.spi.ToolBarFactory;
import org.drombler.acp.core.action.spi.impl.AbstractToolBarHandler;
import org.drombler.acp.core.action.spi.impl.ToolBarResolutionManager;
import org.drombler.acp.core.commons.util.UnresolvedEntry;
import org.drombler.acp.core.commons.util.concurrent.ApplicationThreadExecutorProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.softsmithy.lib.util.PositionableAdapter;

@Component(immediate=true)
@Reference(name="applicationThreadExecutorProvider", referenceInterface=ApplicationThreadExecutorProvider.class)
public class ToolBarsHandler<T, B>
extends AbstractToolBarHandler<T, B> {
    private final ToolBarResolutionManager toolBarResolutionManager = new ToolBarResolutionManager();
    @Reference
    private ToolBarFactory<T> toolBarFactory;
    private Executor applicationExecutor;

    protected void bindToolBarFactory(ToolBarFactory<T> toolBarFactory) {
        this.toolBarFactory = toolBarFactory;
    }

    protected void unbindToolBarFactory(ToolBarFactory<T> toolBarFactory) {
        this.toolBarFactory = null;
    }

    protected void bindApplicationThreadExecutorProvider(ApplicationThreadExecutorProvider applicationThreadExecutorProvider) {
        this.applicationExecutor = applicationThreadExecutorProvider.getApplicationThreadExecutor();
    }

    protected void unbindApplicationThreadExecutorProvider(ApplicationThreadExecutorProvider applicationThreadExecutorProvider) {
        this.applicationExecutor = null;
    }

    @Override
    @Activate
    protected void activate(ComponentContext context) {
        super.activate(context);
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    @Override
    protected void resolveToolBarsType(ToolBarsType toolBarsType, Bundle bundle, BundleContext context) {
        toolBarsType.getToolBar().forEach(toolBarType -> this.resolveToolBar((ToolBarType)toolBarType, bundle, context));
    }

    private void resolveToolBar(ToolBarType toolBarType, Bundle bundle, BundleContext context) {
        if (this.isInitialized()) {
            ToolBarDescriptor toolBarDescriptor = ToolBarDescriptor.createToolBarDescriptor(toolBarType, bundle, this.getToolBarContainer());
            this.resolveToolBar(toolBarDescriptor, context);
        } else {
            this.toolBarResolutionManager.addUnresolvedToolBarType((UnresolvedEntry<ToolBarType>)new UnresolvedEntry((Object)toolBarType, context));
        }
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.toolBarFactory != null && this.applicationExecutor != null;
    }

    protected void resolveToolBar(ToolBarDescriptor toolBarDescriptor, BundleContext context) {
        if (this.isInitialized()) {
            Runnable runnable = () -> {
                T toolBar = this.toolBarFactory.createToolBar(toolBarDescriptor);
                this.getToolBarContainer().addToolBar(toolBarDescriptor.getId(), new PositionableAdapter(toolBar, toolBarDescriptor.getPosition()));
                this.getToolBarContainer().setToolBarVisible(toolBarDescriptor.getId(), toolBarDescriptor.isVisible());
                context.registerService(ToggleActionDescriptor.class, toolBarDescriptor.getShowToolBarActionDescriptor(), null);
                context.registerService(ToggleMenuEntryDescriptor.class, (Object)toolBarDescriptor.getShowToolBarCheckMenuEntryDescriptor(), null);
            };
            this.applicationExecutor.execute(runnable);
        } else {
            this.registerUnresolvedToolBar(toolBarDescriptor, context);
        }
    }

    private void registerUnresolvedToolBar(ToolBarDescriptor toolBarDescriptor, BundleContext context) {
        this.toolBarResolutionManager.addUnresolvedToolBar((UnresolvedEntry<ToolBarDescriptor>)new UnresolvedEntry((Object)toolBarDescriptor, context));
    }

    @Override
    protected void resolveUnresolvedItems() {
        if (this.isInitialized()) {
            this.toolBarResolutionManager.removeUnresolvedToolBarTypes().forEach(unresolvedEntry -> this.resolveToolBar((ToolBarType)unresolvedEntry.getEntry(), unresolvedEntry.getContext().getBundle(), unresolvedEntry.getContext()));
            this.toolBarResolutionManager.removeUnresolvedToolBars().forEach(toolBarDescriptor -> this.resolveToolBar((ToolBarDescriptor)toolBarDescriptor.getEntry(), toolBarDescriptor.getContext()));
        }
    }
}

