/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.drombler.acp.core.action.jaxb.ToolBarsType;
import org.drombler.acp.core.action.spi.ActionFactory;
import org.drombler.acp.core.action.spi.ToolBarButtonFactory;
import org.drombler.acp.core.action.spi.ToolBarEntryDescriptor;
import org.drombler.acp.core.action.spi.impl.AbstractToolBarButtonHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Component(immediate=true)
public class ToolBarButtonHandler<ToolBar, ToolBarButton, Action>
extends AbstractToolBarButtonHandler<ToolBar, ToolBarButton, Action, ToolBarEntryDescriptor> {
    @Reference
    private ToolBarButtonFactory<ToolBarButton, Action> toolBarButtonFactory;
    @Reference
    private ActionFactory<Action> actionFactory;

    protected void bindToolBarButtonFactory(ToolBarButtonFactory<ToolBarButton, Action> toolBarButtonFactory) {
        this.toolBarButtonFactory = toolBarButtonFactory;
        this.resolveUnresolvedItems();
    }

    protected void unbindToolBarButtonFactory(ToolBarButtonFactory<ToolBarButton, Action> toolBarButtonFactory) {
        this.toolBarButtonFactory = null;
    }

    protected void bindActionFactory(ActionFactory<Action> actionFactory) {
        this.actionFactory = actionFactory;
        this.resolveUnresolvedItems();
    }

    protected void unbindActionFactory(ActionFactory<Action> actionFactory) {
        this.actionFactory = null;
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.toolBarButtonFactory != null && this.actionFactory != null;
    }

    @Override
    protected Class<Action> getActionClass() {
        return this.actionFactory.getActionClass();
    }

    @Override
    protected ToolBarButton createToolBarButton(ToolBarEntryDescriptor toolBarEntryDescriptor, Action action, int iconSize) {
        return this.toolBarButtonFactory.createToolBarButton(action, iconSize);
    }

    @Override
    protected void resolveToolBarsType(ToolBarsType toolBarsType, Bundle bundle, BundleContext context) {
        toolBarsType.getToolBarEntry().stream().map(toolBarEntry -> ToolBarEntryDescriptor.createToolBarEntryDescriptor(toolBarEntry)).forEach(toolBarEntryDescriptor -> this.resolveToolBarEntry(toolBarEntryDescriptor, context));
    }
}

