/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.drombler.acp.core.action.jaxb.MenusType;
import org.drombler.acp.core.action.spi.AbstractMenuEntryDescriptor;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.drombler.acp.core.action.spi.ActionFactory;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.MenuEntryDescriptor;
import org.drombler.acp.core.action.spi.MenuItemFactory;
import org.drombler.acp.core.action.spi.impl.AbstractMenuItemHandler;
import org.drombler.acp.core.action.spi.impl.ActionResolutionManager;
import org.drombler.acp.core.action.spi.impl.MenuItemConfig;
import org.drombler.acp.core.commons.util.UnresolvedEntry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
@Reference(name="menuEntryDescriptor", referenceInterface=MenuEntryDescriptor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class MenuItemHandler<MenuItem, Menu extends MenuItem, Action>
extends AbstractMenuItemHandler<MenuItem, Menu, MenuItem, MenuEntryDescriptor<MenuItem, ?>, MenuItemConfig<Action>> {
    @Reference
    private MenuItemFactory<MenuItem, Action> menuItemFactory;
    @Reference
    private ActionFactory<Action> actionFactory;
    private final ActionRegistry<?> actionRegistry = new ActionRegistry<ActionDescriptor>(ActionDescriptor.class);
    private final ActionResolutionManager<MenuEntryDescriptor> actionResolutionManager = new ActionResolutionManager();
    private ServiceTracker<Action, ServiceReference<Action>> tracker;

    protected void bindMenuEntryDescriptor(ServiceReference<MenuEntryDescriptor> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        MenuEntryDescriptor menuEntryDescriptor = (MenuEntryDescriptor)context.getService(serviceReference);
        this.resolveMenuItem(menuEntryDescriptor, context);
    }

    protected void unbindMenuEntryDescriptor(ServiceReference<MenuEntryDescriptor> serviceReference) {
    }

    protected void bindMenuItemFactory(MenuItemFactory<MenuItem, Action> menuItemFactory) {
        this.menuItemFactory = menuItemFactory;
    }

    protected void unbindMenuItemFactory(MenuItemFactory<MenuItem, Action> menuItemFactory) {
        this.menuItemFactory = null;
    }

    protected void bindActionFactory(ActionFactory<Action> actionFactory) {
        this.actionFactory = actionFactory;
    }

    protected void unbindActionFactory(ActionFactory<Action> actionFactory) {
        this.actionFactory = null;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.tracker = this.createActionTracker(context);
        this.tracker.open();
        this.resolveUnresolvedItems();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.tracker.close();
    }

    private ServiceTracker<Action, ServiceReference<Action>> createActionTracker(ComponentContext context) {
        return new ServiceTracker(context.getBundleContext(), this.actionFactory.getActionClass(), new ServiceTrackerCustomizer<Action, ServiceReference<Action>>(){

            public ServiceReference<Action> addingService(ServiceReference<Action> reference) {
                String actionId = MenuItemHandler.this.actionRegistry.getActionId(reference);
                if (MenuItemHandler.this.actionResolutionManager.containsUnresolvedEntries(actionId)) {
                    MenuItemHandler.this.actionResolutionManager.removeUnresolvedEntries(actionId).forEach(unresolvedEntry -> MenuItemHandler.this.resolveMenuItem((AbstractMenuEntryDescriptor)unresolvedEntry.getEntry(), unresolvedEntry.getContext()));
                }
                return reference;
            }

            public void modifiedService(ServiceReference<Action> reference, ServiceReference<Action> service) {
            }

            public void removedService(ServiceReference<Action> reference, ServiceReference<Action> service) {
            }
        });
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.menuItemFactory != null && this.actionFactory != null;
    }

    @Override
    protected void resolveMenuItem(MenusType menusType, Bundle bundle, BundleContext context) {
        menusType.getMenuEntry().stream().map(MenuEntryDescriptor::createMenuEntryDescriptor).forEach(menuEntryDescriptor -> this.resolveMenuItem(menuEntryDescriptor, context));
    }

    @Override
    protected MenuItemConfig<Action> createConfig(MenuEntryDescriptor<MenuItem, ?> menuEntryDescriptor, BundleContext context) {
        Action action = this.actionRegistry.getAction(menuEntryDescriptor.getActionId(), this.actionFactory.getActionClass(), context);
        if (action != null) {
            return new MenuItemConfig<Action>(action);
        }
        return null;
    }

    @Override
    protected MenuItem createMenuItem(MenuEntryDescriptor<MenuItem, ?> menuEntryDescriptor, MenuItemConfig<Action> config) {
        return this.menuItemFactory.createMenuItem(config.getAction(), config.getIconSize());
    }

    @Override
    protected void registerUnresolvedMenuItem(MenuEntryDescriptor<MenuItem, ?> menuEntryDescriptor, BundleContext context) {
        this.actionResolutionManager.addUnresolvedEntry(menuEntryDescriptor.getActionId(), (UnresolvedEntry<MenuEntryDescriptor>)new UnresolvedEntry(menuEntryDescriptor, context));
    }
}

