/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.drombler.acp.core.action.MenuItemSupplierFactory;
import org.drombler.acp.core.action.jaxb.MenusType;
import org.drombler.acp.core.action.spi.MenuDescriptor;
import org.drombler.acp.core.action.spi.MenuFactory;
import org.drombler.acp.core.action.spi.MenuItemContainer;
import org.drombler.acp.core.action.spi.impl.AbstractMenuItemHandler;
import org.drombler.acp.core.action.spi.impl.MenuConfig;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true)
@Reference(name="menuDescriptor", referenceInterface=MenuDescriptor.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class MenuHandler<MenuItem, Menu extends MenuItem>
extends AbstractMenuItemHandler<MenuItem, Menu, Menu, MenuDescriptor<MenuItem, ?>, MenuConfig> {
    @Reference
    private MenuFactory<Menu> menuFactory;

    protected void bindMenuDescriptor(MenuDescriptor menuDescriptor) {
        this.resolveMenu(menuDescriptor);
    }

    protected void unbindMenuDescriptor(MenuDescriptor menuDescriptor) {
    }

    protected void bindMenuFactory(MenuFactory<Menu> menuFactory) {
        this.menuFactory = menuFactory;
    }

    protected void unbindMenuFactory(MenuFactory<Menu> menuFactory) {
        this.menuFactory = null;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resolveUnresolvedItems();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    private void resolveMenu(MenuDescriptor entry) {
        this.resolveMenuItem(entry, null);
    }

    @Override
    protected void resolveMenuItem(MenusType menusType, Bundle bundle, BundleContext context) {
        menusType.getMenu().stream().map(menu -> MenuDescriptor.createMenuDescriptor(menu, bundle)).forEach(menuDescriptor -> this.resolveMenu((MenuDescriptor)menuDescriptor));
    }

    @Override
    protected <F extends MenuItemSupplierFactory<MenuItem, F>> void addToContainer(MenuItemContainer<MenuItem, Menu, F> parentContainer, Menu menu, MenuDescriptor<MenuItem, ?> menuDescriptor) {
        parentContainer.addMenu(menuDescriptor.getId(), menu, menuDescriptor.getMenuItemSupplierFactory(), menuDescriptor.getSortingStrategy());
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.menuFactory != null;
    }

    @Override
    protected MenuConfig createConfig(MenuDescriptor menuEntryDescriptor, BundleContext context) {
        return MenuConfig.getInstance();
    }

    @Override
    protected Menu createMenuItem(MenuDescriptor menuEntryDescriptor, MenuConfig config) {
        return this.menuFactory.createMenu(menuEntryDescriptor);
    }

    @Override
    protected void registerUnresolvedMenuItem(MenuDescriptor menuEntryDescriptor, BundleContext context) {
    }
}

