/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.drombler.acp.core.action.jaxb.ActionType;
import org.drombler.acp.core.action.jaxb.ActionsType;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.drombler.acp.core.action.spi.ActionFactory;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.action.spi.impl.AbstractActionHandler;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class ActionHandler<T>
extends AbstractActionHandler<ActionType, ActionDescriptor<?>> {
    @Reference
    private ActionFactory<T> actionFactory;
    private final ActionRegistry<ActionDescriptor<?>> actionRegistry = new ActionRegistry<ActionDescriptor>(ActionDescriptor.class);

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindActionDescriptor(ServiceReference<ActionDescriptor<?>> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        ActionDescriptor actionDescriptor = (ActionDescriptor)context.getService(serviceReference);
        this.registerActionDescriptor(actionDescriptor, context);
    }

    protected void unbindActionDescriptor(ActionDescriptor<?> actionDescriptor) {
        this.unregisterActionDescriptor(actionDescriptor);
    }

    @Override
    @Activate
    protected void activate(ComponentContext context) {
        super.activate(context);
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    @Override
    protected boolean isInitialized() {
        return super.isInitialized() && this.actionFactory != null;
    }

    @Override
    protected void registerActions(ActionsType actionsType, BundleContext context) {
        actionsType.getAction().forEach(actionType -> this.registerActionType(actionType, context));
    }

    @Override
    protected ActionDescriptor<?> createActionDescriptor(ActionType actionType, BundleContext context, ContextManager contextManager, ContextInjector contextInjector) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        return ActionDescriptor.createActionDescriptor(actionType, context.getBundle(), contextManager, contextInjector);
    }

    @Override
    protected ActionRegistry<ActionDescriptor<?>> getActionRegistry() {
        return this.actionRegistry;
    }

    @Override
    protected void registerActionDescriptor(ActionDescriptor<?> actionDescriptor, BundleContext context) {
        if (this.isInitialized()) {
            this.registerActionDescriptor(actionDescriptor);
            T action = this.actionFactory.createAction(actionDescriptor);
            if (!actionDescriptor.getListenerType().equals(this.actionFactory.getActionClass())) {
                this.registerActionListener(context, actionDescriptor);
            }
            this.getActionRegistry().registerAction(actionDescriptor.getId(), this.actionFactory.getActionClass(), action, context);
        } else {
            this.registerUnresolvedActionDescriptor(actionDescriptor, context);
        }
    }

    private <T> void registerActionListener(BundleContext context, ActionDescriptor<T> actionDescriptor) {
        context.registerService(actionDescriptor.getListenerType(), actionDescriptor.getListener(), null);
    }
}

