/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.drombler.acp.core.action.jaxb.ToolBarsType;
import org.drombler.acp.core.action.spi.ApplicationToolBarContainerProvider;
import org.drombler.acp.core.action.spi.ToolBarContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@References(value={@Reference(name="toolBarsType", referenceInterface=ToolBarsType.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="applicationToolBarContainerProvider", referenceInterface=ApplicationToolBarContainerProvider.class)})
public abstract class AbstractToolBarHandler<T, B> {
    private ToolBarContainer<T, B> toolBarContainer;

    protected void bindToolBarsType(ServiceReference<ToolBarsType> serviceReference) {
        Bundle bundle = serviceReference.getBundle();
        BundleContext context = bundle.getBundleContext();
        ToolBarsType toolBarsType = (ToolBarsType)context.getService(serviceReference);
        this.resolveToolBarsType(toolBarsType, bundle, context);
    }

    protected void unbindToolBarsType(ToolBarsType toolBarsType) {
    }

    protected void bindApplicationToolBarContainerProvider(ApplicationToolBarContainerProvider<T, B> applicationToolBarContainerProvider) {
        this.toolBarContainer = applicationToolBarContainerProvider.getApplicationToolBarContainer();
    }

    protected void unbindApplicationToolBarContainerProvider(ApplicationToolBarContainerProvider<T, B> menuBarMenuContainerProvider) {
        this.toolBarContainer = null;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resolveUnresolvedItems();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    protected abstract void resolveToolBarsType(ToolBarsType var1, Bundle var2, BundleContext var3);

    protected abstract void resolveUnresolvedItems();

    protected boolean isInitialized() {
        return this.toolBarContainer != null;
    }

    protected ToolBarContainer<T, B> getToolBarContainer() {
        return this.toolBarContainer;
    }
}

