/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi.impl;

import java.util.ArrayList;
import java.util.List;
import org.drombler.acp.core.action.jaxb.ActionsType;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.drombler.acp.core.action.spi.ActionRegistry;
import org.drombler.acp.core.commons.util.UnresolvedEntry;
import org.drombler.acp.core.commons.util.concurrent.ApplicationThreadExecutorProvider;
import org.drombler.acp.core.context.ContextManagerProvider;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionHandler<A, D extends ActionDescriptor<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActionHandler.class);
    @Reference
    protected ApplicationThreadExecutorProvider applicationThreadExecutorProvider;
    @Reference
    protected ContextManagerProvider contextManagerProvider;
    private ContextInjector contextInjector;
    private final List<D> actionDescriptors = new ArrayList<D>();
    private final List<UnresolvedEntry<A>> unresolvedActions = new ArrayList<UnresolvedEntry<A>>();
    private final List<UnresolvedEntry<D>> unresolvedActionDescriptors = new ArrayList<UnresolvedEntry<D>>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindActionsType(ServiceReference<ActionsType> serviceReference) {
        BundleContext context = serviceReference.getBundle().getBundleContext();
        ActionsType actionsType = (ActionsType)context.getService(serviceReference);
        this.registerActions(actionsType, context);
    }

    protected void unbindActionsType(ActionsType actionsType) {
    }

    protected void activate(ComponentContext context) {
        this.contextInjector = new ContextInjector(this.getContextManager());
        this.resolveUnresolvedItems();
    }

    protected void deactivate(ComponentContext context) {
        this.actionDescriptors.forEach(this::closeActionDescriptor);
        this.actionDescriptors.clear();
    }

    protected boolean isInitialized() {
        return this.contextManagerProvider != null && this.contextInjector != null && this.applicationThreadExecutorProvider != null;
    }

    protected abstract void registerActions(ActionsType var1, BundleContext var2);

    protected void resolveUnresolvedItems() {
        this.resolveUnresolvedActions();
        this.resolveUnresolvedActionDescriptors();
    }

    private void resolveUnresolvedActions() {
        this.unresolvedActions.forEach(entry -> this.registerActionType(entry.getEntry(), entry.getContext()));
    }

    private void resolveUnresolvedActionDescriptors() {
        this.unresolvedActionDescriptors.forEach(entry -> this.registerActionDescriptor((ActionDescriptor)entry.getEntry(), entry.getContext()));
    }

    protected void registerActionType(A actionType, BundleContext context) {
        if (this.isInitialized()) {
            this.registerActionTypeInitialized(actionType, context);
        } else {
            this.unresolvedActions.add(new UnresolvedEntry(actionType, context));
        }
    }

    private void registerActionTypeInitialized(A actionType, BundleContext context) {
        this.applicationThreadExecutorProvider.getApplicationThreadExecutor().execute(() -> {
            try {
                D actionDescriptor = this.createActionDescriptor(actionType, context, this.getContextManager(), this.contextInjector);
                this.getActionRegistry().registerActionDescriptor(actionDescriptor, context);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        });
    }

    protected abstract D createActionDescriptor(A var1, BundleContext var2, ContextManager var3, ContextInjector var4) throws IllegalAccessException, ClassNotFoundException, InstantiationException;

    protected void closeActionDescriptor(D actionDescriptor) {
        try {
            this.closeActionListener(((ActionDescriptor)actionDescriptor).getListener());
            ((ActionDescriptor)actionDescriptor).setListener(null);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void closeActionListener(Object listener) throws Exception {
        this.getContextManager().removeLocalContext(listener);
        if (listener instanceof AutoCloseable) {
            ((AutoCloseable)listener).close();
        }
    }

    protected abstract void registerActionDescriptor(D var1, BundleContext var2);

    protected abstract ActionRegistry<D> getActionRegistry();

    protected void registerActionDescriptor(D actionDescriptor) {
        this.actionDescriptors.add(actionDescriptor);
    }

    protected void unregisterActionDescriptor(D actionDescriptor) {
        this.closeActionDescriptor(actionDescriptor);
        this.actionDescriptors.remove(actionDescriptor);
    }

    protected void registerUnresolvedActionDescriptor(D actionDescriptor, BundleContext context) {
        this.unresolvedActionDescriptors.add(new UnresolvedEntry(actionDescriptor, context));
    }

    private ContextManager getContextManager() {
        return this.contextManagerProvider.getContextManager();
    }
}

