/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import java.util.MissingResourceException;
import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.action.MenuItemSortingStrategy;
import org.drombler.acp.core.action.MenuItemSupplierFactory;
import org.drombler.acp.core.action.PositionSortingStrategy;
import org.drombler.acp.core.action.PositionableMenuItemAdapterFactory;
import org.drombler.acp.core.action.jaxb.MenuType;
import org.drombler.acp.core.action.spi.AbstractMenuEntryDescriptor;
import org.drombler.acp.core.commons.util.OSGiResourceBundleUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuDescriptor<MenuItem, F extends MenuItemSupplierFactory<MenuItem, F>>
extends AbstractMenuEntryDescriptor<MenuItem, F> {
    private static final Logger LOG = LoggerFactory.getLogger(MenuDescriptor.class);
    private final String id;
    private final String displayName;
    private final MenuItemSortingStrategy<MenuItem, ?> sortingStrategy;

    public MenuDescriptor(String id, String displayName, String path, F menuItemSupplierFactory, MenuItemSortingStrategy<MenuItem, ?> sortingStrategy) {
        super(path, menuItemSupplierFactory);
        this.id = id;
        this.displayName = displayName;
        this.sortingStrategy = sortingStrategy;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public MenuItemSortingStrategy<MenuItem, ?> getSortingStrategy() {
        return this.sortingStrategy;
    }

    public static MenuDescriptor createMenuDescriptor(MenuType menuType, Bundle bundle) {
        try {
            return new MenuDescriptor(StringUtils.stripToNull((String)menuType.getId()), OSGiResourceBundleUtils.getPackageResourceStringPrefixed((String)menuType.getPackage(), (String)menuType.getDisplayName(), (Bundle)bundle), StringUtils.stripToEmpty((String)menuType.getPath()), new PositionableMenuItemAdapterFactory(menuType.getPosition()), new PositionSortingStrategy());
        }
        catch (MissingResourceException ex) {
            LOG.warn("ResourceBundle not found for menu {}: {}", (Object)menuType.getId(), (Object)ex.getMessage());
            throw ex;
        }
    }

    public String toString() {
        return "MenuDescriptor[id=" + this.id + ", displayName=" + this.displayName + ", path=" + this.getPath() + ", sortingStrategy=" + this.sortingStrategy + ']';
    }
}

