/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.regex.Matcher;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionRegistry<D extends ActionDescriptor<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(ActionRegistry.class);
    private static final String BACKSLASH = "\\";
    private static final String NUL = Character.toString('\u0000');
    private final Class<D> actionDescriptorType;

    public ActionRegistry(Class<D> actionDescriptorType) {
        this.actionDescriptorType = actionDescriptorType;
    }

    public <T> T getAction(String actionId, Class<T> actionClass, BundleContext context) {
        try {
            Collection serviceReferences = context.getServiceReferences(actionClass, this.createActionFilter(actionId));
            if (!serviceReferences.isEmpty()) {
                return (T)context.getService((ServiceReference)serviceReferences.iterator().next());
            }
        }
        catch (InvalidSyntaxException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private String escapeLDAPFilter(String actionId) {
        if (actionId.contains(BACKSLASH)) {
            actionId = actionId.replaceAll(Matcher.quoteReplacement(BACKSLASH), "\\5C");
        }
        if (actionId.contains(NUL)) {
            actionId = actionId.replaceAll(NUL, "\\00");
        }
        if (actionId.contains("(")) {
            actionId = actionId.replaceAll("\\(", "\\28");
        }
        if (actionId.contains(")")) {
            actionId = actionId.replaceAll("\\)", "\\29");
        }
        if (actionId.contains("*")) {
            actionId = actionId.replaceAll("\\*", "\\5C");
        }
        return actionId;
    }

    public <T> void registerAction(String actionId, Class<T> actionClass, T action, BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put(ActionDescriptor.ID_KEY, this.escapeLDAPFilter(actionId));
        context.registerService(actionClass, action, properties);
    }

    public String getActionId(ServiceReference<?> reference) {
        return reference.getProperty(ActionDescriptor.ID_KEY).toString();
    }

    public void registerActionDescriptor(D actionDescriptor, BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(1);
        ((Dictionary)properties).put(ActionDescriptor.ID_KEY, this.escapeLDAPFilter(((ActionDescriptor)actionDescriptor).getId()));
        context.registerService(this.actionDescriptorType, actionDescriptor, properties);
    }

    public D getActionDescriptor(String actionId, BundleContext context) {
        try {
            Collection serviceReferences = context.getServiceReferences(this.actionDescriptorType, this.createActionFilter(actionId));
            if (!serviceReferences.isEmpty()) {
                return (D)((ActionDescriptor)context.getService((ServiceReference)serviceReferences.iterator().next()));
            }
        }
        catch (InvalidSyntaxException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private String createActionFilter(String actionId) {
        return "(" + ActionDescriptor.ID_KEY + "=" + this.escapeLDAPFilter(actionId) + ")";
    }
}

