/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.action.jaxb.ActionType;
import org.drombler.acp.core.action.spi.ActionDescriptor;
import org.drombler.commons.client.util.ResourceBundleUtils;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.drombler.commons.context.Contexts;
import org.osgi.framework.Bundle;

class ActionDescriptorUtils {
    private ActionDescriptorUtils() {
    }

    public static <T> void configureActionDescriptor(ActionDescriptor<T> actionDescriptor, ActionType actionType, Bundle bundle, ContextManager contextManager, ContextInjector contextInjector) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        actionDescriptor.setId(StringUtils.stripToNull((String)actionType.getId()));
        actionDescriptor.setDisplayName(ResourceBundleUtils.getPackageResourceStringPrefixed(actionDescriptor.getListenerType(), (String)actionType.getDisplayName()));
        actionDescriptor.setAccelerator(ResourceBundleUtils.getPackageResourceStringPrefixed(actionDescriptor.getListenerType(), (String)actionType.getAccelerator()));
        actionDescriptor.setIcon(StringUtils.stripToNull((String)actionType.getIcon()));
        ActionDescriptorUtils.configureActionDescriptorListener(actionDescriptor, actionDescriptor.getListenerType(), contextManager, contextInjector);
    }

    private static <T> void configureActionDescriptorListener(ActionDescriptor<T> actionDescriptor, Class<T> actionListenerClass, ContextManager contextManager, ContextInjector contextInjector) throws InstantiationException, IllegalAccessException {
        T actionListener = actionListenerClass.newInstance();
        Contexts.configureObject(actionListener, (ContextManager)contextManager, (ContextInjector)contextInjector);
        actionDescriptor.setListener(actionListener);
    }
}

