/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import org.apache.commons.lang3.StringUtils;
import org.drombler.acp.core.action.jaxb.ActionType;
import org.drombler.acp.core.action.spi.ActionDescriptorUtils;
import org.drombler.commons.context.ContextInjector;
import org.drombler.commons.context.ContextManager;
import org.osgi.framework.Bundle;
import org.softsmithy.lib.util.ResourceLoader;

public class ActionDescriptor<T> {
    public static String ID_KEY = "id";
    private final Class<T> listenerType;
    private String id;
    private String displayName;
    private String accelerator;
    private String icon;
    private T listener;
    private final ResourceLoader resourceLoader;

    public ActionDescriptor(Class<T> listenerType) {
        this(listenerType, new ResourceLoader(listenerType));
    }

    public ActionDescriptor(Class<T> listenerType, ResourceLoader resourceLoader) {
        this.listenerType = listenerType;
        this.resourceLoader = resourceLoader;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(String acceleratorKey) {
        this.accelerator = acceleratorKey;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public T getListener() {
        return this.listener;
    }

    public void setListener(T listener) {
        this.listener = listener;
    }

    public Class<T> getListenerType() {
        return this.listenerType;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public static ActionDescriptor<?> createActionDescriptor(ActionType actionType, Bundle bundle, ContextManager contextManager, ContextInjector contextInjector) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class actionListenerClass = bundle.loadClass(StringUtils.stripToNull((String)actionType.getListenerClass()));
        return ActionDescriptor.createActionDescriptor(actionListenerClass, actionType, bundle, contextManager, contextInjector);
    }

    private static <T> ActionDescriptor<T> createActionDescriptor(Class<T> actionListenerClass, ActionType actionType, Bundle bundle, ContextManager contextManager, ContextInjector contextInjector) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ActionDescriptor<T> actionDescriptor = new ActionDescriptor<T>(actionListenerClass);
        ActionDescriptorUtils.configureActionDescriptor(actionDescriptor, actionType, bundle, contextManager, contextInjector);
        return actionDescriptor;
    }

    public String toString() {
        return "ActionDescriptor[id=" + this.id + ", displayName=" + this.displayName + ", listenerType=" + this.listenerType + ", accelerator=" + this.accelerator + ", icon=" + this.icon + ']';
    }
}

