/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drombler.acp.core.action.MenuItemSortingStrategy;
import org.drombler.acp.core.action.MenuItemSupplier;
import org.drombler.acp.core.action.MenuItemSupplierFactory;
import org.drombler.acp.core.action.spi.AbstractMenuItemContainer;
import org.drombler.acp.core.action.spi.MenuItemContainerListener;
import org.drombler.acp.core.action.spi.MenuItemContainerMenuEvent;
import org.drombler.acp.core.action.spi.MenuItemContainerMenuItemEvent;
import org.drombler.acp.core.action.spi.MenuItemRootContainer;
import org.drombler.acp.core.action.spi.MenuMenuItemContainerFactory;
import org.drombler.acp.core.action.spi.SeparatorMenuItemFactory;

public abstract class AbstractMenuItemRootContainer<MenuItem, Menu extends MenuItem, F extends MenuItemSupplierFactory<MenuItem, F>>
extends AbstractMenuItemContainer<MenuItem, Menu, F>
implements MenuItemRootContainer<MenuItem, Menu, F> {
    private final List<MenuItemContainerListener<MenuItem, Menu>> containerListeners = Collections.synchronizedList(new ArrayList());

    public AbstractMenuItemRootContainer(boolean supportingItems, MenuItemSortingStrategy menuItemSortingStrategy, MenuMenuItemContainerFactory<MenuItem, Menu> menuMenuItemContainerFactory, SeparatorMenuItemFactory<? extends MenuItem> separatorMenuItemFactory) {
        super(null, supportingItems, null, menuItemSortingStrategy, menuMenuItemContainerFactory, separatorMenuItemFactory);
    }

    @Override
    public void addMenuContainerListener(MenuItemContainerListener<MenuItem, Menu> containerListener) {
        this.containerListeners.add(containerListener);
    }

    @Override
    public void removeMenuContainerListener(MenuItemContainerListener<MenuItem, Menu> containerListener) {
        this.containerListeners.remove(containerListener);
    }

    void fireMenuAddedEvent(MenuItemSupplier<? extends Menu> menuSupplier, String id, List<String> path) {
        MenuItemContainerMenuEvent event = new MenuItemContainerMenuEvent(this.getMenuItemRootContainer(), menuSupplier, id, path);
        this.containerListeners.forEach(containerListener -> containerListener.menuAdded(event));
    }

    void fireMenuItemAddedEvent(MenuItemSupplier<? extends MenuItem> menuItemSupplier, List<String> path) {
        MenuItemContainerMenuItemEvent event = new MenuItemContainerMenuItemEvent(this.getMenuItemRootContainer(), menuItemSupplier, path);
        this.containerListeners.stream().forEach(containerListener -> containerListener.menuItemAdded(event));
    }

    @Override
    protected AbstractMenuItemRootContainer<MenuItem, Menu, F> getMenuItemRootContainer() {
        return this;
    }
}

