/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drombler.acp.core.action.MenuItemSortingStrategy;
import org.drombler.acp.core.action.MenuItemSupplier;
import org.drombler.acp.core.action.MenuItemSupplierFactory;
import org.drombler.acp.core.action.MenuItemSupplierFactoryEntry;
import org.drombler.acp.core.action.spi.AbstractMenuItemRootContainer;
import org.drombler.acp.core.action.spi.MenuItemContainer;
import org.drombler.acp.core.action.spi.MenuMenuItemContainerFactory;
import org.drombler.acp.core.action.spi.SeparatorMenuItemFactory;

public abstract class AbstractMenuItemContainer<MenuItem, Menu extends MenuItem, F extends MenuItemSupplierFactory<MenuItem, F>>
implements MenuItemContainer<MenuItem, Menu, F> {
    private final Map<String, MenuItemContainer<MenuItem, Menu, ?>> menuContainers = new HashMap();
    private final String id;
    private final boolean supportingItems;
    private final List<MenuItemSupplierFactoryEntry<MenuItem, F>> xMenuItems = new ArrayList<MenuItemSupplierFactoryEntry<MenuItem, F>>();
    private final MenuItemContainer<MenuItem, Menu, ?> parentMenuContainer;
    private final MenuItemSortingStrategy<MenuItem, F> menuItemSortingStrategy;
    private final MenuMenuItemContainerFactory<MenuItem, Menu> menuMenuItemContainerFactory;
    private final SeparatorMenuItemFactory<? extends MenuItem> separatorMenuItemFactory;

    public AbstractMenuItemContainer(String id, boolean supportingItems, MenuItemContainer<MenuItem, Menu, ?> parentMenuContainer, MenuItemSortingStrategy<MenuItem, F> menuItemSortingStrategy, MenuMenuItemContainerFactory<MenuItem, Menu> menuMenuItemContainerFactory, SeparatorMenuItemFactory<? extends MenuItem> separatorMenuItemFactory) {
        this.id = id;
        this.supportingItems = supportingItems;
        this.parentMenuContainer = parentMenuContainer;
        this.menuItemSortingStrategy = menuItemSortingStrategy;
        this.menuMenuItemContainerFactory = menuMenuItemContainerFactory;
        this.separatorMenuItemFactory = separatorMenuItemFactory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public MenuItemContainer<MenuItem, Menu, ?> getParentMenuContainer() {
        return this.parentMenuContainer;
    }

    @Override
    public MenuItemContainer<MenuItem, Menu, ?> getMenuContainer(String id) {
        return this.menuContainers.get(id);
    }

    @Override
    public void addMenu(String id, Menu menu, F supplierFactory, MenuItemSortingStrategy<MenuItem, ?> sortingStrategy) {
        MenuItemContainer<? extends MenuItem, Menu, ?> menuMenuItemContainer = this.menuMenuItemContainerFactory.createMenuMenuItemContainer(id, menu, this, this.getMenuItemRootContainer(), sortingStrategy, this.menuMenuItemContainerFactory, this.separatorMenuItemFactory);
        this.menuContainers.put(id, menuMenuItemContainer);
        this.addMenuItem(menu, supplierFactory, this.getMenus());
        this.fireMenuAddedEvent(supplierFactory.createMenuItemSupplier(menu), id, menuMenuItemContainer);
    }

    private void fireMenuAddedEvent(MenuItemSupplier<? extends Menu> menuSupplier, String id, MenuItemContainer<MenuItem, Menu, ?> menuMenuContainer) {
        this.getMenuItemRootContainer().fireMenuAddedEvent(menuSupplier, id, menuMenuContainer.getPath());
    }

    @Override
    public List<String> getPath() {
        List<String> path;
        if (this.parentMenuContainer != null) {
            path = this.parentMenuContainer.getPath();
            if (this.parentMenuContainer.getId() != null) {
                path.add(this.parentMenuContainer.getId());
            }
        } else {
            path = new ArrayList<String>();
        }
        return path;
    }

    private <T extends MenuItem> void addMenuItem(T menuItem, F supplierFactory, List<? super T> menuItemList) {
        MenuItemSupplierFactoryEntry entry = new MenuItemSupplierFactoryEntry(supplierFactory, menuItem, false);
        int index = this.menuItemSortingStrategy.getMenuItemInsertionPoint(this.xMenuItems, entry);
        this.addMenuItem(index, menuItem, entry, menuItemList);
        Optional separatorInsertionPoint = this.menuItemSortingStrategy.getSeparatorInsertionPoint(index, this.xMenuItems, entry);
        if (separatorInsertionPoint != null && separatorInsertionPoint.isPresent()) {
            int separatorIndex = (Integer)separatorInsertionPoint.get();
            this.addSeparator(separatorIndex, this.separatorMenuItemFactory.createSeparatorMenuItem(), separatorIndex > index ? supplierFactory.toNextSeparatorSupplierFactory() : supplierFactory.toPreviousSeparatorSupplierFactory());
        }
    }

    private <T extends MenuItem> void addMenuItem(int index, T menuItem, MenuItemSupplierFactoryEntry<MenuItem, F> entry, List<? super T> menuItemList) {
        this.xMenuItems.add(index, entry);
        menuItemList.add(index, menuItem);
    }

    private void fireMenuItemAddedEvent(MenuItemSupplier<? extends MenuItem> menuItemSupplier) {
        this.getMenuItemRootContainer().fireMenuItemAddedEvent(menuItemSupplier, this.getPath());
    }

    private void addSeparator(int index, MenuItem separatorMenuItem, F supplierFactory) {
        if (this.isSupportingItems()) {
            this.addMenuItem(index, separatorMenuItem, new MenuItemSupplierFactoryEntry(supplierFactory, separatorMenuItem, true), this.getItems());
            this.fireMenuItemAddedEvent(supplierFactory.createMenuItemSupplier(separatorMenuItem));
        }
    }

    protected abstract List<? super Menu> getMenus();

    @Override
    public void addMenuItem(MenuItem menuItem, F supplierFactory) {
        this.addMenuItem(menuItem, supplierFactory, this.getItems());
        this.fireMenuItemAddedEvent(supplierFactory.createMenuItemSupplier(menuItem));
    }

    protected abstract List<MenuItem> getItems();

    @Override
    public boolean isSupportingItems() {
        return this.supportingItems;
    }

    protected abstract AbstractMenuItemRootContainer<MenuItem, Menu, ?> getMenuItemRootContainer();

    @Override
    public MenuItemSortingStrategy<MenuItem, F> getMenuItemSortingStrategy() {
        return this.menuItemSortingStrategy;
    }
}

