/*
 * Decompiled with CFR 0.152.
 */
package org.drombler.acp.core.action.spi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drombler.acp.core.action.MenuItemSupplierFactory;

public abstract class AbstractMenuEntryDescriptor<MenuItem, F extends MenuItemSupplierFactory<MenuItem, F>> {
    private static final String PATH_DELIMITER = "/";
    private final List<String> path;
    private final F menuItemSupplierFactory;

    protected AbstractMenuEntryDescriptor(String path, F menuItemSupplierFactory) {
        this.path = this.splitPath(path);
        this.menuItemSupplierFactory = menuItemSupplierFactory;
    }

    private List<String> splitPath(String path) {
        if (!(path = path.replaceFirst("^/*", "")).equals("")) {
            return Arrays.asList(path.split(PATH_DELIMITER));
        }
        return Collections.emptyList();
    }

    public List<String> getPath() {
        return this.path;
    }

    public F getMenuItemSupplierFactory() {
        return this.menuItemSupplierFactory;
    }
}

