/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase;

import android.test.AndroidTestCase;
import junit.framework.Assert;
import org.droidparts.annotation.bus.ReceiveEvents;
import org.droidparts.bus.EventBus;
import org.droidparts.bus.EventReceiver;

public class EventBusTestCase
extends AndroidTestCase {
    private final String NAME = "name";
    private final String DATA = "data";
    private int calledBackTimes = 0;
    private final EventReceiver<Object> er = new EventReceiver<Object>(){

        public void onEvent(String name, Object data) {
            EventBusTestCase.this.calledBackTimes++;
            Assert.assertEquals((String)"name", (String)name);
            Assert.assertEquals((Object)"data", (Object)data);
        }
    };
    private final AnnotatedChild aer = new AnnotatedChild();

    protected void tearDown() throws Exception {
        EventBus.unregisterReceiver(this.er);
        EventBus.unregisterAnnotatedReceiver((Object)this.aer);
    }

    public void testEvent() {
        EventBus.registerReceiver(this.er, (String[])new String[0]);
        EventBus.postEvent((String)"name", (Object)"data");
        this.sleep();
        EventBusTestCase.assertEquals((int)1, (int)this.calledBackTimes);
    }

    public void testStikyEvent() {
        EventBus.postEventSticky((String)"name", (Object)"data");
        this.sleep();
        EventBus.registerReceiver(this.er, (String[])new String[0]);
        this.sleep();
        EventBusTestCase.assertEquals((int)1, (int)this.calledBackTimes);
    }

    public void testAnnotatedReceiver() {
        int i;
        for (i = 0; i < 5; ++i) {
            EventBus.registerAnnotatedReceiver((Object)this.aer);
        }
        EventBus.postEvent((String)"whatever");
        for (i = 0; i < 2; ++i) {
            EventBus.postEvent((String)"name", (Object)"data");
        }
        this.sleep();
        EventBusTestCase.assertEquals((int)3, (int)this.aer.parentCalledBackTimes);
        EventBusTestCase.assertEquals((int)2, (int)this.aer.childCalledBackTimes);
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    class AnnotatedChild
    extends AnnotatedParent {
        int childCalledBackTimes;

        AnnotatedChild() {
            this.childCalledBackTimes = 0;
        }

        @ReceiveEvents(name={"name"})
        private void onEvent() {
            ++this.childCalledBackTimes;
        }
    }

    class AnnotatedParent {
        int parentCalledBackTimes = 0;

        AnnotatedParent() {
        }

        @ReceiveEvents
        private void onEvent() {
            ++this.parentCalledBackTimes;
        }
    }
}

