/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.serialize;

import java.util.ArrayList;
import org.droidparts.annotation.serialize.JSON;
import org.droidparts.inner.ConverterRegistry;
import org.droidparts.inner.converter.Converter;
import org.droidparts.inner.converter.ModelConverter;
import org.droidparts.model.Model;
import org.droidparts.persist.serializer.JSONSerializer;
import org.droidparts.test.testcase.serialize.AbstractJSONTestCase;
import org.json.JSONObject;

public class CustomSerializerJSONTestCase
extends AbstractJSONTestCase {
    public void testAlbumCollection() throws Exception {
        JSONSerializer<AlbumCollection> ser = this.makeSerializer(AlbumCollection.class);
        JSONObject obj = this.getJSONObject(2130903042);
        ConverterRegistry.registerConverter((Converter)new AbstractAlbum.Converter());
        AlbumCollection ac = (AlbumCollection)ser.deserialize(obj);
        CustomSerializerJSONTestCase.assertEquals((int)2, (int)ac.albums.size());
        CustomSerializerJSONTestCase.assertTrue((boolean)(ac.albums.get(0) instanceof NameAlbum));
        CustomSerializerJSONTestCase.assertTrue((boolean)(ac.albums.get(1) instanceof YearAlbum));
    }

    public static class YearAlbum
    extends AbstractAlbum {
        private static final long serialVersionUID = 1L;
        @JSON
        public int year;
    }

    public static class NameAlbum
    extends AbstractAlbum {
        private static final long serialVersionUID = 1L;
        @JSON
        public String name;
    }

    public static abstract class AbstractAlbum
    extends Model {
        private static final long serialVersionUID = 1L;

        public static class Converter
        extends ModelConverter<AbstractAlbum> {
            public boolean canHandle(Class<?> cls) {
                return cls == AbstractAlbum.class;
            }

            protected JSONSerializer<? extends AbstractAlbum> getJSONSerializer(Class<AbstractAlbum> valType, JSONObject src) {
                if (src.has("name")) {
                    return new JSONSerializer(NameAlbum.class, null);
                }
                if (src.has("year")) {
                    return new JSONSerializer(YearAlbum.class, null);
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public static class AlbumCollection
    extends Model {
        private static final long serialVersionUID = 1L;
        @JSON
        public ArrayList<AbstractAlbum> albums;
    }
}

