/*
 * Decompiled with CFR 0.152.
 */
package org.droidparts.test.testcase.rest;

import android.test.AndroidTestCase;
import org.droidparts.net.http.HTTPException;
import org.droidparts.net.http.HTTPResponse;
import org.droidparts.net.http.RESTClient;
import org.droidparts.net.http.UserAgent;
import org.droidparts.net.http.worker.HTTPWorker;
import org.droidparts.net.http.worker.HttpClientWorker;

public class RESTClientAuthenticate
extends AndroidTestCase {
    private static final String AUTH_URL = "http://www.httpwatch.com/httpgallery/authentication/authenticatedimage/default.aspx";
    private static final String AUTH_LOGIN = "httpwatch";

    public void testHttpBasicAuth() throws Exception {
        this.testHttpBasicAuth(null);
    }

    public void testHttpBasicAuthLegacy() throws Exception {
        HttpClientWorker worker = new HttpClientWorker(UserAgent.getDefault());
        this.testHttpBasicAuth((HTTPWorker)worker);
    }

    private void testHttpBasicAuth(HTTPWorker worker) throws Exception {
        RESTClient client = worker == null ? new RESTClient(this.getContext()) : new RESTClient(this.getContext(), worker);
        this.testUnauthenticated(client);
        this.testAuthenticatedWrongCredentials(client);
        this.testAuthenticated(client);
    }

    private void testUnauthenticated(RESTClient client) {
        try {
            client.get(AUTH_URL);
            throw new AssertionError();
        }
        catch (HTTPException e) {
            RESTClientAuthenticate.assertEquals((int)401, (int)e.getResponseCode());
            return;
        }
    }

    private void testAuthenticatedWrongCredentials(RESTClient client) {
        client.authenticateBasic("wtf", AUTH_LOGIN);
        try {
            client.get(AUTH_URL);
            throw new AssertionError();
        }
        catch (HTTPException e) {
            RESTClientAuthenticate.assertEquals((int)401, (int)e.getResponseCode());
            return;
        }
    }

    private void testAuthenticated(RESTClient client) throws HTTPException {
        client.authenticateBasic(AUTH_LOGIN, AUTH_LOGIN);
        HTTPResponse resp = client.get(AUTH_URL);
        RESTClientAuthenticate.assertEquals((int)200, (int)resp.code);
    }
}

